/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleTests
extends BaseFixture {
    @Test(description="Implements ATC 6")
    public void verifyStyleReference() {
        NodeList allStyleUrlNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "styleUrl");
        LinkedHashSet<Node> relativeStyleUrls = new LinkedHashSet<Node>();
        LinkedHashSet<Node> absoluteStyleUrls = new LinkedHashSet<Node>();
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < allStyleUrlNodes.getLength(); ++i) {
            Node styleUrl = allStyleUrlNodes.item(i);
            String url = styleUrl.getTextContent();
            URI uri = null;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.StyleReference.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(styleUrl)));
                continue;
            }
            if (uri.isAbsolute()) {
                absoluteStyleUrls.add(styleUrl);
                continue;
            }
            relativeStyleUrls.add(styleUrl);
        }
        for (Node relativeStyleUrl : relativeStyleUrls) {
            this.checkFragmentIdentifier(relativeStyleUrl, errHandler);
            this.checkStyleTarget(relativeStyleUrl, errHandler);
        }
        for (Node absoluteStyleUrl : absoluteStyleUrls) {
            this.checkFragmentIdentifier(absoluteStyleUrl, errHandler);
            this.checkUriScheme(absoluteStyleUrl, errHandler);
            this.checkStyleTarget(absoluteStyleUrl, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 7")
    public void verifySharedStyleHasId() {
        NodeList sharedStyles = null;
        try {
            sharedStyles = XMLUtils.evaluateXPath(this.testSubject, "//kml:Document/kml:Style | //kml:Document/kml:StyleMap", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, this.getClass().getName(), xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < sharedStyles.getLength(); ++i) {
            Element style = (Element)sharedStyles.item(i);
            if (!style.getAttribute("id").isEmpty()) continue;
            this.addError(style, "level1.SharedStyle.err3", errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 36")
    public void verifyStyleMap() {
        NodeList styleMapPairs = null;
        try {
            styleMapPairs = XMLUtils.evaluateXPath(this.testSubject, "//kml:Pair[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < styleMapPairs.getLength(); ++i) {
            Node pair = styleMapPairs.item(i);
            try {
                ETSAssert.assertXPath("kml:key and (kml:styleUrl | kml:Style | kml:StyleMap)", pair, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Pair.err", ((Throwable)((Object)e)).getMessage()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(pair)));
            }
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 37")
    public void verifyItemIconURI() {
        NodeList itemIcons = null;
        try {
            itemIcons = XMLUtils.evaluateXPath(this.testSubject, "//kml:ItemIcon[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < itemIcons.getLength(); ++i) {
            Element itemIcon = (Element)itemIcons.item(i);
            if (itemIcon.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "href").getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ItemIcon.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(itemIcon)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    void checkFragmentIdentifier(Node styleUrl, ValidationErrorHandler errHandler) {
        URI uri;
        try {
            uri = new URI(styleUrl.getTextContent());
        }
        catch (Exception e) {
            this.addError(styleUrl, "level1.StyleReference.err1", errHandler);
            return;
        }
        String fragment = uri.getFragment();
        if (fragment == null) {
            this.addError(styleUrl, "level1.StyleReference.err2", errHandler);
        }
    }

    void checkUriScheme(Node styleUrl, ValidationErrorHandler errHandler) {
        URI uri;
        try {
            uri = new URI(styleUrl.getTextContent());
        }
        catch (Exception e) {
            this.addError(styleUrl, "level1.StyleReference.err1", errHandler);
            return;
        }
        String scheme = uri.getScheme();
        if (!scheme.equals("http")) {
            this.addError(styleUrl, "level1.StyleReference.err3", errHandler);
        }
    }

    void checkStyleTarget(Node styleUrl, ValidationErrorHandler errHandler) {
        Node styleNode;
        URI uri;
        try {
            uri = new URI(styleUrl.getTextContent());
        }
        catch (Exception e) {
            this.addError(styleUrl, "level1.StyleReference.err1", errHandler);
            return;
        }
        String fragment = uri.getFragment();
        if (null == fragment) {
            this.addError(styleUrl, "level1.StyleReference.err4", errHandler);
            return;
        }
        Document rspDoc = null;
        if (uri.toString().startsWith("#")) {
            rspDoc = styleUrl.getOwnerDocument();
        } else if (!uri.isAbsolute()) {
            String uriRef = uri.toString().replaceAll("#" + fragment, "");
            String docURI = styleUrl.getOwnerDocument().getDocumentURI();
            uri = URIUtils.resolveRelativeURI(docURI, uriRef);
        }
        if (null == rspDoc) {
            try {
                rspDoc = URIUtils.parseURI(uri);
            }
            catch (Exception e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.StyleReference.err1", uri), new ErrorLocator(-1, -1, XMLUtils.getXPointer(styleUrl)));
            }
        }
        String xpathExpr = "//*[@id='" + fragment + "']";
        NodeList styleNodeList = null;
        try {
            styleNodeList = XMLUtils.evaluateXPath(rspDoc, xpathExpr, null);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, this.getClass().getName(), xpe);
        }
        Node node = styleNode = styleNodeList.getLength() > 0 ? styleNodeList.item(0) : null;
        if (null == styleNode) {
            this.addError(styleUrl, "level1.StyleReference.err5", errHandler);
            return;
        }
        QName currentStyle = new QName(styleNode.getNamespaceURI(), styleNode.getLocalName());
        if (!currentStyle.getNamespaceURI().equals("http://www.opengis.net/kml/2.2") || !currentStyle.getLocalPart().equals("Style") && !currentStyle.getLocalPart().equals("StyleMap")) {
            this.addError(styleUrl, "level1.StyleReference.err6", errHandler);
        }
    }

    void addError(Node node, String msgKey, ValidationErrorHandler errHandler) {
        errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format(msgKey, new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(node)));
    }
}

