/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class KMLUtils {
    public static Document extractKMLFromArchive(File file) throws IOException, SAXException {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
        Document mainDoc = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destFile = new File(file.getParent(), entry.getName());
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                InputStream input = zipFile.getInputStream(entry);
                FileOutputStream output = new FileOutputStream(destFile);
                int nBytes = IOUtils.copy(input, (OutputStream)output);
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                if (null == mainDoc && destFile.getName().endsWith(".kml")) {
                    mainDoc = URIUtils.parseURI(destFile.toURI());
                }
                if (!TestSuiteLogger.isLoggable(Level.FINER)) continue;
                TestSuiteLogger.log(Level.FINER, String.format("Extracted %d bytes to %s", nBytes, destFile.toURI()));
            }
        }
        return mainDoc;
    }
}

