/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.util;

import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.opengis.cite.kml22.util.NamespaceBindings;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static String writeNodeToString(Node node) {
        StringWriter writer = null;
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "UTF-16");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            writer = new StringWriter();
            idTransformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (TransformerException ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize DOM node: " + node.getNodeName(), ex);
        }
        return writer.toString();
    }

    public static void writeNode(Node node, OutputStream outputStream) {
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("method", "xml");
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            idTransformer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        catch (TransformerException ex) {
            String nodeName = node.getNodeType() == 9 ? ((Document)Document.class.cast(node)).getDocumentElement().getNodeName() : node.getNodeName();
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize DOM node: " + nodeName, ex);
        }
    }

    public static NodeList evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings) throws XPathExpressionException {
        return (NodeList)XMLUtils.evaluateXPath(context, expr, namespaceBindings, XPathConstants.NODESET);
    }

    public static Object evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings, QName returnType) throws XPathExpressionException {
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        return xpath.evaluate(expr, context, returnType);
    }

    public static XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap(domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem(node);
        return xpath.evaluate();
    }

    public static Element createElement(QName qName) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element elem = doc.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        return elem;
    }

    public static List<Element> getElementsByNamespaceURI(Node node, String namespaceURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(namespaceURI)) continue;
            list.add((Element)child);
        }
        return list;
    }

    public static Document transform(Source xslt, Node source) {
        Document sourceDoc = null;
        Document resultDoc = null;
        try {
            resultDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (source.getNodeType() == 9) {
                sourceDoc = (Document)source;
            } else {
                sourceDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                sourceDoc.appendChild(sourceDoc.importNode(source, true));
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        try {
            XsltExecutable exec = compiler.compile(xslt);
            XsltTransformer transformer = exec.load();
            transformer.setSource(new DOMSource(sourceDoc));
            transformer.setDestination(new DOMDestination(resultDoc));
            transformer.transform();
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(e);
        }
        return resultDoc;
    }

    public static String getXPointer(Node node) {
        assert (null != node) : "Input node is null. Log it!";
        StringBuffer xpointer = new StringBuffer();
        String nsURI = node.getNamespaceURI();
        String nsPrefix = node.getPrefix();
        if (null == nsPrefix) {
            nsPrefix = "tns";
        }
        xpointer.append("xmlns(").append(nsPrefix).append("=").append(nsURI).append(")");
        xpointer.append("xpointer((");
        block0 : switch (node.getNodeType()) {
            case 1: {
                NodeList elementsByName = node.getOwnerDocument().getElementsByTagNameNS(nsURI, node.getLocalName());
                for (int i = 0; i < elementsByName.getLength(); ++i) {
                    if (!elementsByName.item(i).isSameNode(node)) continue;
                    xpointer.append("//");
                    xpointer.append(nsPrefix).append(':').append(node.getLocalName()).append(")[").append(i + 1).append("])");
                    break block0;
                }
                break;
            }
            case 9: {
                xpointer.append("/");
                break;
            }
            case 2: {
                System.out.println("getXPointer() doesn't handle attribute nodes yet.");
                break;
            }
            default: {
                System.out.println("Unsupported DOM node type.");
            }
        }
        return xpointer.toString();
    }
}

