/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactory;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureTests
extends BaseFixture {
    @Test(description="Implements ATC 19")
    public void verifyViewVolumeContent() {
        NodeList viewVolNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ViewVolume");
        String[] requiredElems = new String[]{"leftFov", "rightFov", "bottomFov", "topFov", "near"};
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < viewVolNodes.getLength(); ++i) {
            Element viewVolume = (Element)viewVolNodes.item(i);
            for (String elemName : requiredElems) {
                if (viewVolume.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", elemName).getLength() != 0) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ViewVolume.err1", elemName), new ErrorLocator(-1, -1, XMLUtils.getXPointer(viewVolume)));
            }
            if (!(Double.valueOf(viewVolume.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "near").item(0).getTextContent().trim()) < 0.0)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ViewVolume.err3", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(viewVolume)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 24")
    public void verifyPhoneNumberSyntax() {
        NodeList phoneNums = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "phoneNumber");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < phoneNums.getLength(); ++i) {
            Node phoneNumber = phoneNums.item(i);
            String phoneNumberTxt = phoneNumber.getTextContent();
            Pattern phoneNumberPattern = Pattern.compile("tel:(\\+)?(\\d*([-.()])?)+(\\d{3}?[-.()])?(\\d{3}[-.()])?(\\d{4,10})?([;].*)?");
            Matcher matcher = phoneNumberPattern.matcher(phoneNumberTxt);
            if (matcher.matches()) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.PhoneNumber.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(phoneNumber)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 30")
    public void verifyAtomAuthor() {
        NodeList authorNodes = this.testSubject.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "author");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < authorNodes.getLength(); ++i) {
            Element author = (Element)authorNodes.item(i);
            Node uri = author.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "uri").item(0);
            try {
                if (null != uri) {
                    this.assertValidIRI(uri.getTextContent().trim());
                }
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.AtomAuthor.err1", ((Throwable)((Object)e)).getMessage()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(author)));
            }
            Node email = author.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "email").item(0);
            try {
                if (null == email) continue;
                this.assertValidEmailAddr(email.getTextContent().trim());
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.AtomAuthor.err2", ((Throwable)((Object)e)).getMessage()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(author)));
            }
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 31")
    public void verifyAtomLink() {
        NodeList linkNodes = this.testSubject.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "link");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            Element link = (Element)linkNodes.item(i);
            String rel = link.getAttribute("rel");
            if (rel.equals("related")) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.AtomLink.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 33")
    public void verifyAltitudeInGroundOverlay() {
        NodeList grndOverlayAltModeNodes = null;
        try {
            grndOverlayAltModeNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:GroundOverlay/kml:altitudeMode", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < grndOverlayAltModeNodes.getLength(); ++i) {
            Node altitudeMode = grndOverlayAltModeNodes.item(i);
            Node prevSibling = altitudeMode.getPreviousSibling();
            if (!altitudeMode.getTextContent().trim().equals("absolute") || prevSibling.getLocalName().equals("altitude")) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GroundOverlay.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(altitudeMode.getParentNode())));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 35")
    public void verifyPhotoOverlay() {
        NodeList photoOverlays = null;
        try {
            photoOverlays = XMLUtils.evaluateXPath(this.testSubject, "//kml:PhotoOverlay[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        String[] requiredElems = new String[]{"Icon", "ViewVolume", "Point", "Camera"};
        for (int i = 0; i < photoOverlays.getLength(); ++i) {
            Element photoOverlay = (Element)photoOverlays.item(i);
            for (String elemName : requiredElems) {
                if (photoOverlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", elemName).getLength() != 0) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.PhotoOverlayMinimal.err", elemName), new ErrorLocator(-1, -1, XMLUtils.getXPointer(photoOverlay)));
            }
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 41")
    public void verifyRegion() {
        NodeList regionNodes = null;
        try {
            regionNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Region[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < regionNodes.getLength(); ++i) {
            Node region = regionNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:LatLonAltBox and kml:Lod", region, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Region.err", ((Throwable)((Object)e)).getMessage()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(region)));
            }
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 39")
    public void verifyRegionLod() {
        NodeList lodNodes = null;
        try {
            lodNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Lod[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < lodNodes.getLength(); ++i) {
            Element lod = (Element)lodNodes.item(i);
            Node minLodPixelsNode = lod.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "minLodPixels").item(0);
            if (null == minLodPixelsNode) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Lod.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(lod)));
                continue;
            }
            double minLodPixels = Double.parseDouble(minLodPixelsNode.getTextContent());
            double maxLodPixels = Double.POSITIVE_INFINITY;
            Node maxLodPixelsNode = lod.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "maxLodPixels").item(0);
            if (null != maxLodPixelsNode) {
                Double value = Double.parseDouble(maxLodPixelsNode.getTextContent().trim());
                double d = maxLodPixels = value < 0.0 ? Double.POSITIVE_INFINITY : value;
            }
            if (!(minLodPixels >= maxLodPixels)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Lod.err3", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(lod)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    void assertValidEmailAddr(String emailAddr) {
        Pattern emailPattern = Pattern.compile("(.+)@(.+)\\.(.+)");
        Matcher matcher = emailPattern.matcher(emailAddr);
        if (!matcher.matches()) {
            throw new AssertionError((Object)("Not a valid address: " + emailAddr));
        }
    }

    void assertValidIRI(String id) {
        try {
            IRI iRI = IRIFactory.iriImplementation().construct(id);
        }
        catch (IRIException e) {
            throw new AssertionError((Object)("Not a valid IRI reference:" + id));
        }
    }
}

