/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import java.util.LinkedHashSet;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemporalElementTests
extends BaseFixture {
    @Test(description="Implements ATC 4")
    public void verifyTimeSpan() {
        NodeList allTimeSpanNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "TimeSpan");
        LinkedHashSet<Element> indefiniteTimeSpans = new LinkedHashSet<Element>();
        LinkedHashSet<Element> definiteTimeSpans = new LinkedHashSet<Element>();
        for (int i = 0; i < allTimeSpanNodes.getLength(); ++i) {
            Element timeSpan = (Element)allTimeSpanNodes.item(i);
            NodeList nodeList = timeSpan.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "begin");
            NodeList endNodes = timeSpan.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "end");
            if (nodeList.getLength() > 0 && endNodes.getLength() > 0) {
                definiteTimeSpans.add(timeSpan);
                continue;
            }
            indefiniteTimeSpans.add(timeSpan);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (Node node : indefiniteTimeSpans) {
            this.checkIndefiniteInterval((Element)node, errHandler);
        }
        for (Node node : definiteTimeSpans) {
            this.checkInterval((Element)node, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toXml());
    }

    @Test(description="Implements ATC 5")
    public void verifyTimeStamp() {
        NodeList timeStampNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "TimeStamp");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < timeStampNodes.getLength(); ++i) {
            Element timeStamp = (Element)timeStampNodes.item(i);
            NodeList whenNodes = timeStamp.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "when");
            if (whenNodes.getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.TimeStamp.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(timeStamp)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toXml());
    }

    void checkIndefiniteInterval(Element timeSpan, ValidationErrorHandler errHandler) {
        NodeList beginNodes = timeSpan.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "begin");
        NodeList endNodes = timeSpan.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "end");
        if (beginNodes.getLength() == 0 && endNodes.getLength() == 0) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.TimeSpan.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(timeSpan)));
        }
    }

    void checkInterval(Element timeSpan, ValidationErrorHandler errHandler) {
        NodeList beginNodes = timeSpan.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "begin");
        NodeList endNodes = timeSpan.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "end");
        String begin = beginNodes.item(0).getTextContent();
        String end = endNodes.item(0).getTextContent();
        DateTime beginDate = this.parseDateTime(begin);
        DateTime endDate = this.parseDateTime(end);
        if (beginDate == null || endDate == null) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.TimeSpan.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(timeSpan)));
            return;
        }
        if (beginDate.getMillis() >= endDate.getMillis()) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.TimeSpan.err3", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(timeSpan)));
        }
    }

    DateTime parseDateTime(String str) {
        DateTimeFormatter formatter = ISODateTimeFormat.dateOptionalTimeParser();
        DateTime dateTime = null;
        try {
            dateTime = formatter.parseDateTime(str);
        }
        catch (Exception e) {
            return null;
        }
        return dateTime;
    }
}

