/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.LogUtils;
import com.occamlab.te.util.Misc;
import com.occamlab.te.util.TEPath;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewLog {
    public static boolean hasCache = false;
    static String testName = " ";
    public static TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static boolean view_log(String suiteName, File logdir, String session, ArrayList tests, Templates templates, Writer out) throws Exception {
        String tfile = new String(logdir.getAbsolutePath() + "/" + session);
        TEPath tpath = new TEPath(tfile);
        if (!tpath.isValid()) {
            System.out.println("ViewLog Error: Invalid log file name " + tfile);
            return false;
        }
        return ViewLog.view_log(suiteName, logdir, session, tests, templates, out, 1);
    }

    public static Element getElementByTagName(Node node, String tagname) {
        NodeList nl;
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagName(tagname);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagName(tagname);
        } else {
            return null;
        }
        if (nl.getLength() >= 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public static boolean view_log(String suiteName, File logdir, String session, ArrayList tests, Templates templates, Writer out, int testnum) throws Exception {
        TEPath tpath = new TEPath(logdir.getAbsolutePath());
        if (!tpath.isValid()) {
            System.out.println("ViewLog Error: Invalid log file name " + logdir);
            return false;
        }
        hasCache = false;
        Transformer t = templates.newTransformer();
        t.setParameter("sessionDir", session);
        t.setParameter("TESTNAME", suiteName);
        t.setParameter("logdir", logdir.getAbsolutePath());
        t.setParameter("testnum", Integer.toString(testnum));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (tests.isEmpty() && session == null) {
            Document doc = db.newDocument();
            Element sessions_e = doc.createElement("sessions");
            doc.appendChild(sessions_e);
            String[] children = logdir.list();
            for (int i = 0; i < children.length; ++i) {
                if (!new File(logdir, children[i]).isDirectory()) continue;
                Element session_e = doc.createElement("session");
                session_e.setAttribute("id", children[i]);
                sessions_e.appendChild(session_e);
            }
            t.transform(new DOMSource(doc), new StreamResult(out));
            return true;
        }
        if (tests.isEmpty()) {
            File session_dir = new File(logdir, session);
            if (!session_dir.isDirectory()) {
                System.out.println("Error: Directory " + session_dir.getAbsolutePath() + " does not exist.");
                return false;
            }
            Document doc = LogUtils.makeTestList(logdir, session);
            if (doc == null) {
                return false;
            }
            t.transform(new DOMSource(doc), new StreamResult(out));
            Element testElement = DomUtils.getElementByTagName(doc, "test");
            if (testElement == null) {
                return false;
            }
            ViewLog.setHasCache(testElement);
            return testElement.getAttribute("complete").equals("yes");
        }
        boolean ret = true;
        for (String test : tests) {
            File f = new File(new File(logdir, test), "log.xml");
            if (f.exists()) {
                Document doc = LogUtils.makeTestList(logdir, test);
                if (doc == null) {
                    return false;
                }
                Element testElement = DomUtils.getElementByTagName(doc, "test");
                if (testElement != null) {
                    ViewLog.setHasCache(testElement);
                }
                t.setParameter("index", doc);
                Document log = LogUtils.readLog(logdir, test);
                t.transform(new DOMSource(log), new StreamResult(out));
                Element logElement = (Element)log.getElementsByTagName("log").item(0);
                NodeList endtestlist = logElement.getElementsByTagName("endtest");
                ret = ret && endtestlist.getLength() > 0;
                continue;
            }
            System.out.println("Error: " + f.getAbsolutePath() + " does not exist.");
            if (ret) {
                // empty if block
            }
            ret = false;
        }
        return ret;
    }

    static void setHasCache(Element testElement) {
        String hasCacheAttributeValue = testElement.getAttribute("hasCache");
        hasCache = hasCacheAttributeValue == null ? false : hasCacheAttributeValue.equals("yes");
    }

    public static boolean hasCache() {
        return hasCache;
    }

    public static void main(String[] args) throws Exception {
        String testName = null;
        File logdir = null;
        String session = null;
        ArrayList<String> tests = new ArrayList<String>();
        String cmd = "java com.occamlab.te.ViewLog";
        String style = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-style=")) {
                style = args[i].substring(7);
                continue;
            }
            if (args[i].startsWith("-cmd=")) {
                cmd = args[i].substring(5);
                continue;
            }
            if (args[i].startsWith("-logdir=")) {
                logdir = new File(args[i].substring(8));
                continue;
            }
            if (args[i].startsWith("-session=")) {
                session = args[i].substring(9);
                continue;
            }
            if (args[i].startsWith("-")) continue;
            tests.add(args[i]);
        }
        if (logdir == null) {
            System.out.println();
            System.out.println("To list sessions in a log directory:");
            System.out.println("  " + cmd + " -logdir=dir\n");
            System.out.println("To list tests in a session:");
            System.out.println("  " + cmd + " -logdir=dir -session=session\n");
            System.out.println("To view detailed results for tests:");
            System.out.println("  " + cmd + " -logdir=dir test1 [test2] ...");
            return;
        }
        File stylesheet = Misc.getResourceAsFile("com/occamlab/te/logstyles/default.xsl");
        if (style != null && !(stylesheet = new File(stylesheet.getParent(), style + ".xsl")).exists()) {
            System.out.println("Invalid style '" + style + "': " + stylesheet.getAbsolutePath() + " does not exist.");
            return;
        }
        Templates templates = transformerFactory.newTemplates(new StreamSource(stylesheet));
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        ViewLog.view_log(testName, logdir, session, tests, templates, out);
    }
}

