/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources;

import com.occamlab.te.spi.jaxrs.ErrorResponseBuilder;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import com.occamlab.te.spi.jaxrs.TestSuiteRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

@Path(value="suites/{etsCode}/")
public class TestSuiteOverviewResource {
    private static final String APPLICATION_TEXT_HTML = "text/html";
    private static final String APPLICATION_XML = "application/xml";
    private static final String APPLICATION_JSON = "application/json";

    @GET
    @Produces(value={"text/html; charset='utf-8'"})
    public InputStream getTestSuiteDescriptionAsHTML(@PathParam(value="etsCode") String etsCode) {
        InputStream atsStream = this.getTestSuiteDescription(etsCode, APPLICATION_TEXT_HTML);
        if (null == atsStream) {
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(404, "Test suite overview not found.");
            throw new WebApplicationException(rsp);
        }
        return atsStream;
    }

    @GET
    @Produces(value={"application/xml; charset='utf-8'"})
    public InputStream getTestSuiteDescriptionAsXML(@PathParam(value="etsCode") String etsCode) {
        InputStream atsStream = this.getTestSuiteDescription(etsCode, APPLICATION_XML);
        if (null == atsStream) {
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(404, "Test suite overview not found.");
            throw new WebApplicationException(rsp);
        }
        return atsStream;
    }

    @GET
    @Produces(value={"application/json"})
    public InputStream getTestSuiteDescriptionasJSON(@PathParam(value="etsCode") String etsCode) {
        InputStream atsStream = this.getTestSuiteDescription(etsCode, APPLICATION_JSON);
        if (null == atsStream) {
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(404, "Test suite overview not found.");
            throw new WebApplicationException(rsp);
        }
        return atsStream;
    }

    private StringBuilder createPathToDoc(String etsCode, String extension) {
        StringBuilder docPath = new StringBuilder();
        docPath.append("/doc/");
        docPath.append(etsCode);
        docPath.append("/");
        docPath.append(this.findVersion(etsCode));
        docPath.append("/overview.");
        docPath.append(extension);
        return docPath;
    }

    private String findVersion(String code) throws WebApplicationException {
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        TestSuiteController controller = registry.getController(code);
        if (null == controller) {
            throw new WebApplicationException(404);
        }
        return controller.getVersion();
    }

    private InputStream getTestSuiteDescription(String etsCode, String preferredMediaType) {
        StringBuilder overviewXml = this.createPathToDoc(etsCode, "xml");
        InputStream atsStream = this.getClass().getResourceAsStream(overviewXml.toString());
        if (null != atsStream) {
            File resultFile = null;
            String resourceFile = null;
            if (preferredMediaType.contains("xml")) {
                return atsStream;
            }
            if (preferredMediaType.contains("html")) {
                StringBuilder overviewHtml = this.createPathToDoc(etsCode, "html");
                InputStream atsStream1 = this.getClass().getResourceAsStream(overviewHtml.toString());
                if (null != atsStream1) {
                    return atsStream1;
                }
                resultFile = new File(System.getProperty("java.io.tmpdir"), "testsuiteoverview.html");
                resourceFile = "com/occamlab/te/test_suite_overview_html.xsl";
            } else if (preferredMediaType.contains("json")) {
                resultFile = new File(System.getProperty("java.io.tmpdir"), "testsuiteoverview.json");
                resourceFile = "com/occamlab/te/test_suite_overview_json.xsl";
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String testSuiteOverviewXsl = cl.getResource(resourceFile).toString();
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer(new StreamSource(testSuiteOverviewXsl));
                transformer.transform(new StreamSource(atsStream), new StreamResult(resultFile));
                atsStream = new FileInputStream(resultFile);
            }
            catch (FileNotFoundException | TransformerException e) {
                throw new RuntimeException(e);
            }
        } else {
            overviewXml = this.createPathToDoc(etsCode, "html");
            atsStream = this.getClass().getResourceAsStream(overviewXml.toString());
        }
        return atsStream;
    }
}

