/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.logging.Level;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.KmlGeometryUnmarshaller;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.ValidationUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpatialTests
extends BaseFixture {
    @Test(description="Implements ATC 3")
    public void verifyGeometryCoordinates() {
        NodeList coordinatesNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coordinates");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < coordinatesNodes.getLength(); ++i) {
            Node coordinates = coordinatesNodes.item(i);
            ValidationUtils.validateCoordinateTuples(coordinates, 2, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 8")
    public void verifyLatLonAltBox() {
        NodeList latLonAltBoxNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LatLonAltBox");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < latLonAltBoxNodes.getLength(); ++i) {
            Element latLonAltBox = (Element)latLonAltBoxNodes.item(i);
            this.checkLonValues(latLonAltBox, errHandler);
            this.checkLatValues(latLonAltBox, errHandler);
            this.checkAltValues(latLonAltBox, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 11")
    public void verifyLatLonBox() {
        NodeList boxNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LatLonBox");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < boxNodes.getLength(); ++i) {
            Element box = (Element)boxNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:north and kml:south and kml:east and kml:west", box, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonBox.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(box)));
                continue;
            }
            this.checkLonValues(box, errHandler);
            this.checkLatValues(box, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 12")
    public void verifyGeometryExtrude() {
        NodeList extrudeNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "extrude");
        LinkedHashSet<Node> allExtrudedGeometries = new LinkedHashSet<Node>();
        for (int i = 0; i < extrudeNodes.getLength(); ++i) {
            Node extrude = extrudeNodes.item(i);
            String value = extrude.getTextContent().trim();
            if (!value.equals("true") && !value.equals("1")) continue;
            allExtrudedGeometries.add(extrude.getParentNode());
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (Node extrudeGeometry : allExtrudedGeometries) {
            this.checkAltitudeModeNotClampToGround((Element)extrudeGeometry, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 13")
    public void verifyGeometryTesselate() {
        NodeList tessellateNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "tessellate");
        LinkedHashSet<Node> allTessellatedGeometries = new LinkedHashSet<Node>();
        for (int i = 0; i < tessellateNodes.getLength(); ++i) {
            Node tessellate = tessellateNodes.item(i);
            String value = tessellate.getTextContent().trim();
            if (!value.equals("true") && !value.equals("1")) continue;
            allTessellatedGeometries.add(tessellate.getParentNode());
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (Node tessellatedGeom : allTessellatedGeometries) {
            try {
                ETSAssert.assertXPath("not(kml:altitudeMode) or (kml:altitudeMode = 'clampToGround')", tessellatedGeom, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryTessellate.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(tessellatedGeom)));
            }
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 14")
    public void verifyPointCoordinates() {
        NodeList pointCoords = null;
        try {
            pointCoords = XMLUtils.evaluateXPath(this.testSubject, "//kml:Point/kml:coordinates", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < pointCoords.getLength(); ++i) {
            Node pointCoordNode = pointCoords.item(i);
            String coordinates = pointCoordNode.getTextContent();
            String[] tuples = coordinates.trim().split("[ \\t\\n\\r]{1,}");
            if (tuples.length <= 1) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Point.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(pointCoordNode.getParentNode())));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 15")
    public void verifyLineStringCoordinates() {
        NodeList lineCoords = null;
        try {
            lineCoords = XMLUtils.evaluateXPath(this.testSubject, "//kml:LineString/kml:coordinates", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < lineCoords.getLength(); ++i) {
            Node lineCoordNode = lineCoords.item(i);
            String coordinates = lineCoordNode.getTextContent().trim();
            String[] tuples = coordinates.split("[ \\t\\n\\r]{1,}");
            if (tuples.length >= 2) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LineString.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(lineCoordNode.getParentNode())));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 16")
    public void verifyLinearRingIsClosed() {
        NodeList ringCoords = null;
        try {
            ringCoords = XMLUtils.evaluateXPath(this.testSubject, "//kml:LinearRing/kml:coordinates", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < ringCoords.getLength(); ++i) {
            Object[] endPoint;
            Node ringCoordNode = ringCoords.item(i);
            String coordinates = ringCoordNode.getTextContent().trim();
            String[] tuples = coordinates.split("[ \\t\\n\\r]{1,}");
            if (tuples.length < 4) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinearRingControlPoints.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(ringCoordNode.getParentNode())));
                continue;
            }
            Object[] startPoint = tuples[0].split(",");
            if (Arrays.equals(startPoint, endPoint = tuples[tuples.length - 1].split(","))) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinearRingControlPoints.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(ringCoordNode.getParentNode())));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 17")
    public void verifyPolygonBoundary() {
        NodeList polygons = null;
        try {
            polygons = XMLUtils.evaluateXPath(this.testSubject, "//kml:Polygon[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < polygons.getLength(); ++i) {
            Element polygon = (Element)polygons.item(i);
            if (polygon.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "outerBoundaryIs").getLength() == 0) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.PolygonBoundary.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(polygon)));
                continue;
            }
            this.checkInnerBoundaries(polygon, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 29")
    public void verifyTextureFileAliasInModel() {
        NodeList aliasNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Alias");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        Element resourceMap = null;
        for (int i = 0; i < aliasNodes.getLength(); ++i) {
            Element alias = (Element)aliasNodes.item(i);
            if (null == resourceMap) {
                resourceMap = (Element)alias.getParentNode();
            }
            try {
                ETSAssert.assertReferentExists("kml:targetHref", alias, null, "image/*");
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkReferents.err1", ((Throwable)((Object)e)).getMessage()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(alias)));
            }
        }
        if (null != resourceMap) {
            this.checkModelResourceMap(resourceMap, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 32")
    public void verifyModelOrientationNotEmpty() {
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(this.testSubject, "//kml:Orientation[not(ancestor::kml:Update) and not(kml:*)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node emptyOrientation = nodeList.item(i);
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.OrientationMinimal.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(emptyOrientation)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 34")
    public void verifyModelContent() {
        NodeList modelNodes = null;
        try {
            modelNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Model[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < modelNodes.getLength(); ++i) {
            Element model = (Element)modelNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:Link and kml:Location", model, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Model.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(model)));
            }
            NodeList resourceMaps = model.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ResourceMap");
            if (resourceMaps.getLength() <= 0) continue;
            this.checkModelResourceMap((Element)resourceMaps.item(0), errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkModelResourceMap(Element resourceMap, ValidationErrorHandler errHandler) {
        File sourceModel = null;
        try {
            Node modelHref = (Node)XMLUtils.evaluateXPath(resourceMap, "../kml:Link/kml:href", NS_MAP, XPathConstants.NODE);
            URI modelUri = URI.create(modelHref.getTextContent().trim());
            if (!modelUri.isAbsolute()) {
                String base = resourceMap.getOwnerDocument().getDocumentURI();
                modelUri = URI.create(base).resolve(modelUri);
            }
            sourceModel = URIUtils.dereferenceURI(modelUri);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Unable to locate Model referent. ", e);
        }
        if (null == sourceModel) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Alias.err4", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(resourceMap.getParentNode())));
            return;
        }
        NodeList aliases = resourceMap.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Alias");
        for (int i = 0; i < aliases.getLength(); ++i) {
            Element alias = (Element)aliases.item(i);
            Element sourceHref = (Element)alias.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "sourceHref").item(0);
            URI sourceURI = URI.create(sourceHref.getTextContent().trim());
            int lastSlash = sourceURI.toString().lastIndexOf("/");
            String sourceFileName = lastSlash > -1 ? sourceURI.toString().substring(lastSlash + 1) : sourceURI.toString();
            boolean foundFileName = false;
            Scanner scanner = null;
            try {
                scanner = new Scanner(sourceModel);
                while (scanner.hasNextLine()) {
                    if (scanner.nextLine().indexOf(sourceFileName) <= -1) continue;
                    foundFileName = true;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                TestSuiteLogger.log(Level.FINE, "Model not found.", e);
            }
            finally {
                if (null != scanner) {
                    scanner.close();
                }
            }
            if (foundFileName) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Alias.err5", sourceFileName), new ErrorLocator(-1, -1, XMLUtils.getXPointer(alias)));
        }
    }

    void checkInnerBoundaries(Element polygonElem, ValidationErrorHandler errHandler) {
        NodeList ringNodes = polygonElem.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LinearRing");
        if (ringNodes.getLength() > 1) {
            Element outerRingElem = (Element)ringNodes.item(0);
            KmlGeometryUnmarshaller unmarshaller = new KmlGeometryUnmarshaller();
            LinearRing outerRing = (LinearRing)unmarshaller.unmarshalKmlGeometry(outerRingElem);
            GeometryFactory geoFactory = new GeometryFactory();
            Polygon polygon = geoFactory.createPolygon(outerRing, null);
            for (int i = 1; i < ringNodes.getLength(); ++i) {
                Element ringElem = (Element)ringNodes.item(i);
                LinearRing innerRing = (LinearRing)unmarshaller.unmarshalKmlGeometry(ringElem);
                if (innerRing.within(polygon)) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.PolygonBoundary.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(ringNodes.item(i))));
            }
        }
    }

    void checkAltitudeModeNotClampToGround(Element geometry, ValidationErrorHandler errHandler) {
        NodeList altitudeModeNodes = geometry.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitudeMode");
        if (altitudeModeNodes.getLength() == 0) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryExtrude.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(geometry)));
            return;
        }
        String altitudeMode = altitudeModeNodes.item(0).getTextContent().trim();
        if (altitudeMode.equals("clampToGround")) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryExtrude.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(geometry)));
        }
    }

    void checkLonValues(Element box, ValidationErrorHandler errHandler) {
        NodeList eastNodes = box.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "east");
        NodeList westNodes = box.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "west");
        Float east = new Float(180.0f);
        Float west = new Float(-180.0f);
        if (eastNodes.getLength() != 0) {
            east = Float.valueOf(eastNodes.item(0).getTextContent());
        }
        if (westNodes.getLength() != 0) {
            west = Float.valueOf(westNodes.item(0).getTextContent());
        }
        if (east == null || west == null) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(box)));
            return;
        }
        if (east.floatValue() <= west.floatValue()) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(box)));
        }
    }

    void checkLatValues(Element box, ValidationErrorHandler errHandler) {
        NodeList northNodes = box.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "north");
        NodeList southNodes = box.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "south");
        Float north = new Float(180.0f);
        Float south = new Float(-180.0f);
        if (northNodes.getLength() != 0) {
            north = Float.valueOf(northNodes.item(0).getTextContent());
        }
        if (southNodes.getLength() != 0) {
            south = Float.valueOf(southNodes.item(0).getTextContent());
        }
        if (north == null || south == null) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err3", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(box)));
            return;
        }
        if (north.floatValue() <= south.floatValue()) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err4", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(box)));
        }
    }

    void checkAltValues(Element latLonAltBox, ValidationErrorHandler errHandler) {
        NodeList minAltitudeNodes = latLonAltBox.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "minAltitude");
        NodeList maxAltitudeNodes = latLonAltBox.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "maxAltitude");
        if (minAltitudeNodes.getLength() != 0 && maxAltitudeNodes.getLength() != 0) {
            this.checkAltMode(latLonAltBox, errHandler);
        }
        Float minAltitude = new Float(0.0f);
        Float maxAltitude = new Float(0.0f);
        if (minAltitudeNodes.getLength() != 0) {
            minAltitude = Float.valueOf(minAltitudeNodes.item(0).getTextContent());
        }
        if (maxAltitudeNodes.getLength() != 0) {
            maxAltitude = Float.valueOf(maxAltitudeNodes.item(0).getTextContent());
        }
        if (minAltitude == null || maxAltitude == null) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err5", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(latLonAltBox)));
            return;
        }
        if (minAltitude.floatValue() > maxAltitude.floatValue()) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err6", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(latLonAltBox)));
        }
    }

    void checkAltMode(Element latLonAltBox, ValidationErrorHandler errHandler) {
        String altitudeModeStr;
        boolean altitudeModeExists;
        NodeList altitudeModeNodes = latLonAltBox.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitudeMode");
        boolean bl = altitudeModeExists = altitudeModeNodes.getLength() > 0;
        if (!altitudeModeExists) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err7", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(latLonAltBox)));
            return;
        }
        if (altitudeModeExists && (altitudeModeStr = altitudeModeNodes.item(0).getTextContent()).equals("clampToGround")) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LatLonAltBox.err8", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(latLonAltBox)));
        }
    }
}

