/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import java.util.logging.Level;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewTests
extends BaseFixture {
    @Test(description="Implements ATC 38")
    public void verifyLookAt() {
        NodeList lookAtNodes = null;
        try {
            lookAtNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:LookAt[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < lookAtNodes.getLength(); ++i) {
            Element lookAt = (Element)lookAtNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:longitude and kml:latitude and kml:range", lookAt, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LookAt.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(lookAt)));
            }
            try {
                ETSAssert.assertXPath("not(kml:altitudeMode) or (kml:altitudeMode = 'clampToGround') or kml:altitude", lookAt, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LookAt.err4", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(lookAt)));
            }
            this.checkTiltRange(lookAt, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    void checkTiltRange(Element lookAt, ValidationErrorHandler errHandler) {
        double tilt;
        Node tiltNode = lookAt.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "tilt").item(0);
        if (null != tiltNode && ((tilt = Double.parseDouble(tiltNode.getTextContent())) < 0.0 || tilt > 90.0)) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LookAt.err3", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(lookAt)));
        }
    }
}

