/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KmlGeometryUnmarshaller {
    private static final Logger LOGR = Logger.getLogger(KmlGeometryUnmarshaller.class.getPackage().getName());
    private String namespaceURI;
    private GeometryFactory geoFactory;

    public KmlGeometryUnmarshaller() {
        this("http://www.opengis.net/kml/2.2");
    }

    public KmlGeometryUnmarshaller(String namespaceURI) {
        this.namespaceURI = namespaceURI;
        this.geoFactory = new GeometryFactory();
    }

    public Geometry unmarshalKmlGeometry(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType != 9 && nodeType != 1) {
            throw new IllegalArgumentException("Expect Document or Element node as input to unmarshalKmlGeometry(Node node)");
        }
        Element geoElem = null;
        if (nodeType == 9) {
            Document root = (Document)node;
            geoElem = root.getDocumentElement();
        } else {
            geoElem = (Element)node;
        }
        String localName = geoElem.getLocalName();
        Geometry geom = null;
        if (localName.equals("Point")) {
            geom = this.unmarshalPoint(geoElem);
        } else if (localName.equals("LineString")) {
            geom = this.unmarshalLineString(geoElem);
        } else if (localName.equals("LinearRing")) {
            geom = this.unmarshalLinearRing(geoElem);
        } else if (localName.equals("Polygon")) {
            geom = this.unmarshalPolygon(geoElem);
        } else if (localName.equals("MultiGeometry")) {
            geom = this.unmarshalMultiGeometry(geoElem);
        } else {
            throw new IllegalArgumentException("Unsupported KML geometry type");
        }
        return geom;
    }

    Point unmarshalPoint(Element geoElem) {
        assert (geoElem.getLocalName().equals("Point")) : "Expected Point element as input";
        Node coords = geoElem.getElementsByTagNameNS(this.namespaceURI, "coordinates").item(0);
        CoordinateArraySequence cas = this.buildCoordinateArraySequence(coords);
        Point pt = this.geoFactory.createPoint(cas);
        return pt;
    }

    LineString unmarshalLineString(Element geoElem) {
        assert (geoElem.getLocalName().startsWith("LineString")) : "Expected LineString as input";
        Node coords = geoElem.getElementsByTagNameNS(this.namespaceURI, "coordinates").item(0);
        CoordinateArraySequence cas = this.buildCoordinateArraySequence(coords);
        LineString line = this.geoFactory.createLineString(cas);
        return line;
    }

    LinearRing unmarshalLinearRing(Element geoElem) {
        assert (geoElem.getLocalName().equals("LinearRing")) : "Expected LinearRing element as input";
        LinearRing ring = null;
        Node coords = geoElem.getElementsByTagNameNS(this.namespaceURI, "coordinates").item(0);
        CoordinateArraySequence cas = this.buildCoordinateArraySequence(coords);
        ring = this.geoFactory.createLinearRing(cas);
        return ring;
    }

    Polygon unmarshalPolygon(Element geoElem) {
        assert (geoElem.getLocalName().equals("Polygon")) : "Expected Polygon element as input";
        NodeList boundary = geoElem.getElementsByTagNameNS(this.namespaceURI, "LinearRing");
        int nRings = boundary.getLength();
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>(nRings);
        for (int i = 0; i < nRings; ++i) {
            Element ringElem = (Element)boundary.item(i);
            LinearRing ring = this.unmarshalLinearRing(ringElem);
            rings.add(ring);
        }
        Polygon poly = this.geoFactory.createPolygon((LinearRing)rings.remove(0), rings.toArray(new LinearRing[nRings - 1]));
        return poly;
    }

    GeometryCollection unmarshalMultiGeometry(Element geoElem) {
        assert (geoElem.getLocalName().equals("MultiGeometry")) : "Expected MultiGeometry element as input";
        NodeList members = geoElem.getChildNodes();
        int nMembers = members.getLength();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(nMembers);
        for (int i = 0; i < nMembers; ++i) {
            Element geomElem = (Element)members.item(i);
            Geometry geom = this.unmarshalKmlGeometry(geomElem);
            geometries.add(geom);
        }
        GeometryCollection geomColl = this.geoFactory.createGeometryCollection(geometries.toArray(new Geometry[nMembers]));
        return geomColl;
    }

    CoordinateArraySequence buildCoordinateArraySequence(Node coords) {
        assert (coords.getLocalName().equals("coordinates")) : "Expected coordinates element as input";
        String[] tuples = coords.getTextContent().trim().split("\\s+");
        int nTuples = tuples.length;
        if (LOGR.isLoggable(Level.FINER)) {
            LOGR.finer("nTuples: " + nTuples);
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(nTuples);
        for (int i = 0; i < nTuples; ++i) {
            Coordinate coord = null;
            String[] values = tuples[i].split(",");
            int crsDim = values.length;
            if (crsDim < 2 || crsDim > 3) {
                throw new IllegalArgumentException("Not a 2D or 3D coordinate tuple: " + tuples[i]);
            }
            coord = crsDim == 2 ? new Coordinate(Double.parseDouble(values[0]), Double.parseDouble(values[1])) : new Coordinate(Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2]));
            coordinates.add(coord);
        }
        Coordinate[] tupleArray = coordinates.toArray(new Coordinate[nTuples]);
        CoordinateArraySequence cas = new CoordinateArraySequence(tupleArray);
        return cas;
    }
}

