/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodGroupsHelper {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    static void collectMethodsByGroup(ITestNGMethod[] methods, boolean forTests, List<ITestNGMethod> outIncludedMethods, List<ITestNGMethod> outExcludedMethods, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        for (ITestNGMethod tm : methods) {
            boolean in = false;
            Method m3 = tm.getMethod();
            if (forTests) {
                in = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(finder, m3), runInfo, tm, forTests, unique, outIncludedMethods);
            } else {
                IConfigurationAnnotation annotation = AnnotationHelper.findConfiguration(finder, m3);
                if (annotation.getAlwaysRun()) {
                    if (!unique || !MethodGroupsHelper.isMethodAlreadyPresent(outIncludedMethods, tm)) {
                        in = true;
                    }
                } else {
                    in = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(finder, tm), runInfo, tm, forTests, unique, outIncludedMethods);
                }
            }
            if (in) {
                outIncludedMethods.add(tm);
                continue;
            }
            outExcludedMethods.add(tm);
        }
    }

    private static boolean includeMethod(ITestOrConfiguration annotation, RunInfo runInfo, ITestNGMethod tm, boolean forTests, boolean unique, List<ITestNGMethod> outIncludedMethods) {
        boolean result = false;
        if (MethodHelper.isEnabled(annotation) && runInfo.includeMethod(tm, forTests)) {
            if (unique) {
                if (!MethodGroupsHelper.isMethodAlreadyPresent(outIncludedMethods, tm)) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private static boolean isMethodAlreadyPresent(List<ITestNGMethod> result, ITestNGMethod tm) {
        for (ITestNGMethod m3 : result) {
            Class<?> c2;
            Class<?> c1;
            Method jm1 = m3.getMethod();
            Method jm2 = tm.getMethod();
            if (!jm1.getName().equals(jm2.getName()) || !(c1 = jm1.getDeclaringClass()).isAssignableFrom(c2 = jm2.getDeclaringClass()) && !c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, List<ITestNGMethod>> findGroupsMethods(Collection<ITestClass> classes, boolean before) {
        Map<String, List<ITestNGMethod>> result = Maps.newHashMap();
        for (ITestClass cls : classes) {
            ITestNGMethod[] methods;
            for (ITestNGMethod method : methods = before ? cls.getBeforeGroupsMethods() : cls.getAfterGroupsMethods()) {
                for (String group : before ? method.getBeforeGroups() : method.getAfterGroups()) {
                    List<ITestNGMethod> methodList = result.get(group);
                    if (methodList == null) {
                        methodList = Lists.newArrayList();
                        result.put(group, methodList);
                    }
                    if (methodList.contains(method)) continue;
                    methodList.add(method);
                }
            }
        }
        return result;
    }

    protected static void findGroupTransitiveClosure(XmlMethodSelector xms, List<ITestNGMethod> includedMethods, List<ITestNGMethod> allMethods, String[] includedGroups, Set<String> outGroups, Set<ITestNGMethod> outMethods) {
        boolean bl;
        Map<ITestNGMethod, ITestNGMethod> runningMethods = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : includedMethods) {
            runningMethods.put(iTestNGMethod, iTestNGMethod);
        }
        Map<String, String> runningGroups = Maps.newHashMap();
        for (String thisGroup : includedGroups) {
            runningGroups.put(thisGroup, thisGroup);
        }
        boolean bl2 = true;
        Map<ITestNGMethod, ITestNGMethod> newMethods = Maps.newHashMap();
        while (bl) {
            for (ITestNGMethod m4 : includedMethods) {
                String[] mdu;
                String[] ig;
                for (String g2 : ig = m4.getGroupsDependedUpon()) {
                    ITestNGMethod[] im;
                    if (runningGroups.containsKey(g2)) continue;
                    runningGroups.put(g2, g2);
                    for (ITestNGMethod thisMethod : im = MethodGroupsHelper.findMethodsThatBelongToGroup(m4, allMethods.toArray(new ITestNGMethod[allMethods.size()]), g2)) {
                        if (runningMethods.containsKey(thisMethod)) continue;
                        runningMethods.put(thisMethod, thisMethod);
                        newMethods.put(thisMethod, thisMethod);
                    }
                }
                for (String tm : mdu = m4.getMethodsDependedUpon()) {
                    ITestNGMethod thisMethod = MethodGroupsHelper.findMethodNamed(tm, allMethods);
                    if (thisMethod == null || runningMethods.containsKey(thisMethod)) continue;
                    runningMethods.put(thisMethod, thisMethod);
                    newMethods.put(thisMethod, thisMethod);
                }
            }
            bl = newMethods.size() > 0;
            includedMethods = Lists.newArrayList();
            includedMethods.addAll(newMethods.keySet());
            newMethods = Maps.newHashMap();
        }
        outMethods.addAll(runningMethods.keySet());
        outGroups.addAll(runningGroups.keySet());
    }

    private static ITestNGMethod findMethodNamed(String tm, List<ITestNGMethod> allMethods) {
        for (ITestNGMethod m3 : allMethods) {
            String methodName = m3.getMethod().getDeclaringClass().getName() + "." + m3.getMethodName();
            if (!methodName.equals(tm)) continue;
            return m3;
        }
        return null;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, ITestNGMethod[] methods, String groupRegexp) {
        ITestNGMethod[] found = MethodGroupsHelper.findMethodsThatBelongToGroup(methods, groupRegexp);
        if (found.length == 0) {
            method.setMissingGroup(groupRegexp);
        }
        return found;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod[] methods, String groupRegexp) {
        List vResult = Lists.newArrayList();
        Pattern pattern = MethodGroupsHelper.getPattern(groupRegexp);
        for (ITestNGMethod tm : methods) {
            String[] groups;
            for (String group : groups = tm.getGroups()) {
                Boolean match = MethodGroupsHelper.isMatch(pattern, group);
                if (!match.booleanValue()) continue;
                vResult.add(tm);
            }
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    private static Boolean isMatch(Pattern pattern, String group) {
        Pair<String, String> cacheKey = Pair.create(pattern.pattern(), group);
        Boolean match = MATCH_CACHE.get(cacheKey);
        if (match == null) {
            match = pattern.matcher(group).matches();
            MATCH_CACHE.put(cacheKey, match);
        }
        return match;
    }

    private static Pattern getPattern(String groupRegexp) {
        Pattern groupPattern = PATTERN_CACHE.get(groupRegexp);
        if (groupPattern == null) {
            groupPattern = Pattern.compile(groupRegexp);
            PATTERN_CACHE.put(groupRegexp, groupPattern);
        }
        return groupPattern;
    }
}

