/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.SuiteAttribute;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.opengis.cite.validation.XSModelBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KmlDocumentTests
extends BaseFixture {
    @Test(description="Implements ATC 1")
    public void verifyDocumentElement() {
        Element docElement = this.testSubject.getDocumentElement();
        Assert.assertEquals((String)docElement.getLocalName(), (String)"kml", (String)"Document element has unexpected [local name].");
        Assert.assertEquals((String)docElement.getNamespaceURI(), (String)"http://www.opengis.net/kml/2.2", (String)"Document element has unexpected [namespace name].");
    }

    @Test(description="Implements ATC 2")
    public void verifyXmlSchemaConstraints(ITestContext testContext) {
        Schema kmlSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.KML_SCHEMA.getName());
        Validator validator = kmlSchema.newValidator();
        DOMSource source = new DOMSource(this.testSubject);
        ETSAssert.assertSchemaValid(validator, source);
    }

    @Test(description="Implements ATC 21")
    public void verifyEmptyObjectHasId(ITestContext testContext) {
        NodeList kmlElemsNotInUpdate = null;
        try {
            kmlElemsNotInUpdate = XMLUtils.evaluateXPath(this.testSubject, "//kml:*[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        Schema kmlSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.KML_SCHEMA.getName());
        XSModel xsdModel = XSModelBuilder.buildXMLSchemaModel((Schema)kmlSchema, (String)"http://www.opengis.net/kml/2.2");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < kmlElemsNotInUpdate.getLength(); ++i) {
            XSElementDeclaration subDecl;
            XSElementDeclaration declSubGroup;
            XSElementDeclaration subGroup;
            Element kmlElem = (Element)kmlElemsNotInUpdate.item(i);
            XSElementDeclaration decl = xsdModel.getElementDeclaration(kmlElem.getLocalName(), kmlElem.getNamespaceURI());
            if (decl == null || (subGroup = decl.getSubstitutionGroupAffiliation()) == null) continue;
            while ((declSubGroup = (subDecl = xsdModel.getElementDeclaration(subGroup.getName(), subGroup.getNamespace())).getSubstitutionGroupAffiliation()) != null) {
                subGroup = declSubGroup;
            }
            if (subGroup == null || !subGroup.getName().equals("AbstractObjectGroup")) continue;
            this.checkEmptyElementHasIdAttribute(kmlElem, errHandler);
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    void checkEmptyElementHasIdAttribute(Element kmlElem, ValidationErrorHandler errHandler) {
        if (kmlElem.getChildNodes().getLength() == 0 && kmlElem.getAttribute("id").isEmpty()) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.EmptyObjects.err", kmlElem.getNamespaceURI(), kmlElem.getLocalName()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(kmlElem)));
        }
    }
}

