/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.KMLUtils;
import org.opengis.cite.kml22.util.NamespaceBindings;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ETSAssert {
    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals((String)node.getLocalName(), (String)qName.getLocalPart(), (String)ErrorMessage.get("LocalName"));
        Assert.assertEquals((String)node.getNamespaceURI(), (String)qName.getNamespaceURI(), (String)ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            TestSuiteLogger.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Assert.assertTrue((boolean)result, (String)ErrorMessage.format("XPathResult", context.getNodeName(), expr));
    }

    public static void assertXPath2(String expr, Source source, Map<String, String> namespaceBindings) {
        XdmValue result = null;
        try {
            result = XMLUtils.evaluateXPath2(source, expr, namespaceBindings);
        }
        catch (SaxonApiException e) {
            throw new AssertionError((Object)ErrorMessage.format("XPathError", expr + e.getMessage()));
        }
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("XPathResult", source.getSystemId(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        SchematronValidator validator;
        try {
            validator = new SchematronValidator((Source)new StreamSource(schemaRef.toString()), "#ALL");
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        DOMResult result = (DOMResult)validator.validate(xmlSource);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals((int)features.getLength(), (int)expectedCount, (String)String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertReferentExists(String xpath, Node linkNode, Client httpClient, String ... mediaTypes) {
        URI uriRef = null;
        try {
            String href = (String)XMLUtils.evaluateXPath(linkNode, xpath, BaseFixture.NS_MAP, XPathConstants.STRING);
            uriRef = URI.create(href.trim());
        }
        catch (XPathExpressionException xpe) {
            throw new AssertionError((Object)("Failed to evaluate XPath expression " + xpath));
        }
        if (uriRef.toString().isEmpty()) {
            throw new AssertionError((Object)("URI reference not found in " + linkNode.getNodeName() + xpath));
        }
        ETSAssert.assertReferentExists(uriRef, linkNode.getOwnerDocument().getBaseURI(), httpClient, mediaTypes);
    }

    public static void assertReferentExists(URI uriRef, String baseURI, Client httpClient, String ... mediaTypes) {
        if (null == httpClient) {
            httpClient = Client.create();
        }
        httpClient.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        if (uriRef.isAbsolute() && !uriRef.getScheme().equals("file")) {
            ClientRequest.Builder reqBuilder = ClientRequest.create();
            reqBuilder.accept(mediaTypes);
            ClientRequest req = reqBuilder.build(uriRef, "GET");
            ClientResponse rsp = httpClient.handle(req);
            if (rsp.getStatusInfo().getFamily() == Response.Status.Family.REDIRECTION) {
                URI newURI = rsp.getLocation();
                req.setURI(newURI);
                rsp = httpClient.handle(req);
            }
            if (rsp.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new AssertionError((Object)("No acceptable resource available at " + uriRef));
            }
        } else {
            URI uri = URIUtils.resolveRelativeURI(baseURI, uriRef.toString());
            File fileRef = null;
            try {
                fileRef = URIUtils.dereferenceURI(uri);
            }
            catch (IOException iox) {
                throw new AssertionError((Object)("Unable to access resource at " + uri));
            }
            if (fileRef.length() == 0L) {
                throw new AssertionError((Object)("No content found at " + uri));
            }
        }
    }

    public static void assertValidUpdate(Node updateNode) {
        Document kmlData;
        if (!updateNode.getLocalName().equals("Update")) {
            return;
        }
        Element updateElem = (Element)updateNode;
        URI targetHref = URI.create(updateElem.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "targetHref").item(0).getTextContent().trim());
        if (!targetHref.isAbsolute()) {
            String docURI = updateNode.getOwnerDocument().getDocumentURI();
            targetHref = URIUtils.resolveRelativeURI(docURI, targetHref.toString());
        }
        File kmlFile = null;
        try {
            try {
                kmlFile = URIUtils.dereferenceURI(targetHref);
                kmlData = URIUtils.parseURI(kmlFile.toURI());
            }
            catch (SAXException e) {
                kmlData = KMLUtils.extractKMLFromArchive(kmlFile);
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Failed to parse KML resource from " + targetHref));
        }
        try {
            NodeList targetIdList = XMLUtils.evaluateXPath(updateNode, "//kml:*/@targetId", BaseFixture.NS_MAP);
            for (int i = 0; i < targetIdList.getLength(); ++i) {
                Node targetIdNode = targetIdList.item(i);
                String expr = String.format("//kml:*[@id='%s']", targetIdNode.getTextContent());
                ETSAssert.assertXPath(expr, kmlData, BaseFixture.NS_MAP);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
    }
}

