/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import org.opengis.cite.kml22.SuiteAttribute;
import org.opengis.cite.kml22.TestRunArg;
import org.opengis.cite.kml22.util.KMLUtils;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.ValidationUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        Schema kmlSchema = ValidationUtils.createKMLSchema();
        if (null != kmlSchema) {
            suite.setAttribute(SuiteAttribute.KML_SCHEMA.getName(), (Object)kmlSchema);
        }
        this.processSuiteParameters(suite);
    }

    public void onFinish(ISuite suite) {
        Reporter.clear();
        Reporter.log((String)"Test suite parameters:");
        Reporter.log((String)suite.getXmlSuite().getAllParameters().toString());
    }

    void processSuiteParameters(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        Integer level = new Integer(1);
        if (null != params.get(TestRunArg.ICS.toString())) {
            try {
                level = Integer.valueOf((String)params.get(TestRunArg.ICS.toString()));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        suite.setAttribute(SuiteAttribute.LEVEL.getName(), (Object)level);
        String iutParam = (String)params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to access resource located at " + iutRef, iox);
        }
        Document kmlDoc = null;
        try {
            try {
                kmlDoc = URIUtils.parseURI(entityFile.toURI());
            }
            catch (SAXException e) {
                kmlDoc = KMLUtils.extractKMLFromArchive(entityFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read KML document from file at " + entityFile.toURI(), e);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)kmlDoc);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(kmlDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }
}

