/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.queries;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class QueryCollections
extends CommonFixture {
    boolean disable = true;
    protected URI iut;

    @DataProvider(name="collectionIDs")
    public Iterator<Object[]> collectionIDs(ITestContext testContext) {
        this.iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        Set<String> collectionTypes = this.extractCollectionIDs(this.iut);
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        collectionsData.add(new Object[]{collectionTypes});
        return collectionsData.iterator();
    }

    private Set<String> extractCollectionIDs(URI rootUri) {
        Response request = (Response)this.init().baseUri(rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        JsonPath response = request.jsonPath();
        List collections = response.getList("collections");
        HashSet<String> collectionTypes = new HashSet<String>();
        for (Object collection : collections) {
            Map collectionMap = (Map)collection;
            Object collectionType = collectionMap.get("id");
            collectionTypes.add((String)collectionType);
        }
        return collectionTypes;
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 34 (/conf/position), Abstract Test 50 (/conf/area), Abstract Test 66 (/conf/cube), Abstract Test 82 (/conf/trajectory), Abstract Test 100 (/conf/corridor), Abstract Test 136 (/conf/locations) ")
    public void validateNoQueryParameters(Object collectionIdentifiers) {
        if (this.disable) {
            throw new SkipException("Test has been Disabled");
        }
        Set collectionIds = (Set)collectionIdentifiers;
        for (String colletionId : collectionIds) {
            String url = this.rootUri.toString() + "/collections/" + colletionId;
            Response response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/position", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 34. Expected status code 400 when a Position query with no query parameters are specified for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/area", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 50. Expected status code 400 when a Area query with no query parameters are specified for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/trajectory", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 82. Expected status code 400 when a Trajectory query with no query parameters are specified for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/locations", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 136. Expected status code 400 when a Locations query with no query parameters are specified for collection " + colletionId);
        }
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 35 (/conf/position),Abstract Test 36 (/conf/position), Abstract Test 51 (/conf/area), Abstract Test 83 (/conf/trajectory), Abstract Test 101 (/conf/corridor)")
    public void validateCoordsQueryParameters(Object collectionIdentifiers) {
        if (this.disable) {
            throw new SkipException("Test has been Disabled");
        }
        Set collectionIds = (Set)collectionIdentifiers;
        for (String colletionId : collectionIds) {
            String url = this.rootUri.toString() + "/collections/" + colletionId;
            Response response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/position?coords=", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 35. Expected status code 400 when a Position query with coords query parameter is not specified for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/position?coords=POINT()", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 36. Expected status code 400 when a Position coords query parameter does not contain a valid POINT Well Known Text value for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/area?coords=", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Expected status code 400 when a Area query with coords query parameter is not specified for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/trajectory?coords=", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Expected status code 400 when a Trajectory query with coords query parameter is not specified for collection " + colletionId);
            response = (Response)this.init().baseUri(url).accept(ContentType.JSON).when().request(Method.GET, "/corridor?coords=", new Object[0]);
            EtsAssert.assertTrue(response.getStatusCode() == 400, "Expected status code 400 when a Corridor query with coords query parameter is not specified for collection " + colletionId);
        }
    }
}

