/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.JSONPointer;

public class SchemaLocation {
    private final URI rootDocumentURI;
    private final List<String> pointerToLocation;

    public static final SchemaLocation empty() {
        return new SchemaLocation(null, Collections.emptyList());
    }

    public static final SchemaLocation parseURI(String uri) {
        try {
            int hashmarkIdx = uri.indexOf("#");
            if (hashmarkIdx > -1) {
                String rawPointer;
                String rootDocumentURI;
                if (hashmarkIdx == uri.length() - 1) {
                    rootDocumentURI = uri;
                    rawPointer = "";
                } else {
                    rootDocumentURI = uri.substring(0, hashmarkIdx);
                    rawPointer = uri.substring(hashmarkIdx + 1);
                }
                URI documentURI = "".equals(rootDocumentURI) ? null : new URI(rootDocumentURI);
                return new SchemaLocation(documentURI, new JSONPointer(rawPointer).getRefTokens());
            }
            return new SchemaLocation(new URI(uri), Collections.emptyList());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SchemaLocation(URI rootDocumentURI, List<String> pointerToLocation) {
        this.rootDocumentURI = rootDocumentURI;
        this.pointerToLocation = new ArrayList<String>((Collection)Objects.requireNonNull(pointerToLocation, "pointerToLocation cannot be null"));
    }

    public SchemaLocation(List<String> pointerToLocation) {
        this.rootDocumentURI = null;
        this.pointerToLocation = pointerToLocation;
    }

    public SchemaLocation addPointerSegment(String key) {
        ArrayList<String> newPointer = new ArrayList<String>(this.pointerToLocation.size() + 1);
        newPointer.addAll(this.pointerToLocation);
        newPointer.add(key);
        return new SchemaLocation(this.rootDocumentURI, newPointer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaLocation)) {
            return false;
        }
        SchemaLocation that = (SchemaLocation)o;
        return Objects.equals(this.rootDocumentURI, that.rootDocumentURI) && this.pointerToLocation.equals(that.pointerToLocation);
    }

    public int hashCode() {
        return Objects.hash(this.rootDocumentURI, this.pointerToLocation);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.rootDocumentURI != null) {
            buffer.append(this.rootDocumentURI.toString());
        }
        if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '#' && !this.pointerToLocation.isEmpty()) {
            buffer.append("#");
        }
        this.pointerToLocation.stream().map(JSONPointer::escape).forEach(e -> buffer.append("/").append((String)e));
        return buffer.toString();
    }
}

