/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.internal.referencing.PositionTransformer;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.Bezier;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.GeodesicsOnEllipsoid;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class GeodeticCalculator {
    static final double LATITUDE_THRESHOLD = 1.5706706731410454E-10;
    private final PositionTransformer userToGeodetic;
    final Ellipsoid ellipsoid;
    final double semiMajorAxis;
    double \u03c61;
    double \u03bb1;
    double \u03c62;
    double \u03bb2;
    double msin\u03b11;
    double mcos\u03b11;
    double msin\u03b12;
    double mcos\u03b12;
    double geodesicDistance;
    double rhumblineLength;
    double rhumblineAzimuth;
    private int validity;
    static final int START_POINT = 1;
    static final int END_POINT = 2;
    static final int STARTING_AZIMUTH = 4;
    static final int ENDING_AZIMUTH = 8;
    static final int GEODESIC_DISTANCE = 16;
    static final int RHUMBLINE_LENGTH = 32;
    static final int COEFFICIENTS_FOR_START_POINT = 64;

    GeodeticCalculator(CoordinateReferenceSystem coordinateReferenceSystem, Ellipsoid ellipsoid) {
        GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem, true, true);
        if (geographicCRS == null) {
            throw new IllegalArgumentException(Errors.format((short)47, ReferencingUtilities.getInterface((IdentifiedObject)coordinateReferenceSystem)));
        }
        this.ellipsoid = ellipsoid;
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.userToGeodetic = new PositionTransformer(coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS, null);
    }

    public static GeodeticCalculator create(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureNonNull("crs", coordinateReferenceSystem);
        Ellipsoid ellipsoid = ReferencingUtilities.getEllipsoid(coordinateReferenceSystem);
        if (ellipsoid == null) {
            throw new IllegalArgumentException(Errors.format((short)47, ReferencingUtilities.getInterface((IdentifiedObject)coordinateReferenceSystem)));
        }
        if (ellipsoid.isSphere()) {
            return new GeodeticCalculator(coordinateReferenceSystem, ellipsoid);
        }
        return new GeodesicsOnEllipsoid(coordinateReferenceSystem, ellipsoid);
    }

    final boolean isInvalid(int n) {
        return (this.validity & n) != n;
    }

    final void setValid(int n) {
        this.validity |= n;
    }

    public CoordinateReferenceSystem getPositionCRS() {
        return this.userToGeodetic.defaultCRS;
    }

    public GeographicCRS getGeographicCRS() {
        return (GeographicCRS)this.userToGeodetic.getCoordinateReferenceSystem();
    }

    private PositionTransformer geographic(double d, double d2) {
        this.userToGeodetic.setOrdinate(0, Math.toDegrees(d));
        this.userToGeodetic.setOrdinate(1, Math.toDegrees(d2));
        int n = this.userToGeodetic.getDimension();
        while (--n >= 2) {
            this.userToGeodetic.setOrdinate(n, 0.0);
        }
        return this.userToGeodetic;
    }

    private String transformError(boolean bl) {
        return Resources.format((short)89, bl ? 1 : 0, IdentifiedObjects.getName((IdentifiedObject)this.getPositionCRS(), null));
    }

    public DirectPosition getStartPoint() {
        if (this.isInvalid(1)) {
            throw new IllegalStateException(Resources.format((short)88, 0));
        }
        try {
            return this.geographic(this.\u03c61, this.\u03bb1).inverseTransform();
        }
        catch (TransformException transformException) {
            throw new GeodeticException(this.transformError(true), transformException);
        }
    }

    public void setStartPoint(Position position) {
        DirectPosition directPosition;
        try {
            directPosition = this.userToGeodetic.transform(position.getDirectPosition());
        }
        catch (TransformException transformException) {
            throw new IllegalArgumentException(this.transformError(false), transformException);
        }
        this.setStartGeographicPoint(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
    }

    public void setStartGeographicPoint(double d, double d2) {
        ArgumentChecks.ensureFinite("latitude", d);
        ArgumentChecks.ensureFinite("longitude", d2);
        this.\u03c61 = Math.toRadians(Math.max(-90.0, Math.min(90.0, d)));
        this.\u03bb1 = Math.toRadians(d2);
        this.validity = 1;
    }

    public DirectPosition getEndPoint() {
        if (this.isInvalid(2)) {
            this.computeEndPoint();
        }
        try {
            return this.geographic(this.\u03c62, this.\u03bb2).inverseTransform();
        }
        catch (TransformException transformException) {
            throw new GeodeticException(this.transformError(true), transformException);
        }
    }

    public void setEndPoint(Position position) {
        DirectPosition directPosition;
        try {
            directPosition = this.userToGeodetic.transform(position.getDirectPosition());
        }
        catch (TransformException transformException) {
            throw new IllegalArgumentException(this.transformError(false), transformException);
        }
        this.setEndGeographicPoint(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
    }

    public void setEndGeographicPoint(double d, double d2) {
        ArgumentChecks.ensureFinite("latitude", d);
        ArgumentChecks.ensureFinite("longitude", d2);
        this.\u03c62 = Math.toRadians(Math.max(-90.0, Math.min(90.0, d)));
        this.\u03bb2 = Math.toRadians(d2);
        this.setValid(2);
        this.validity &= 0xFFFFFF83;
    }

    public double getStartingAzimuth() {
        if (this.isInvalid(4)) {
            this.computeDistance();
        }
        return Math.toDegrees(Math.atan2(this.msin\u03b11, this.mcos\u03b11));
    }

    public void setStartingAzimuth(double d) {
        ArgumentChecks.ensureFinite("azimuth", d);
        d = Math.toRadians(d);
        this.msin\u03b11 = Math.sin(d);
        this.mcos\u03b11 = Math.cos(d);
        this.setValid(4);
        this.validity &= 0xFFFFFF95;
    }

    public double getEndingAzimuth() {
        if (this.isInvalid(8)) {
            if (this.isInvalid(2)) {
                this.computeEndPoint();
            } else {
                this.computeDistance();
            }
        }
        return Math.toDegrees(Math.atan2(this.msin\u03b12, this.mcos\u03b12));
    }

    public double getConstantAzimuth() {
        if (this.isInvalid(32)) {
            this.computeRhumbLine();
        }
        return Math.toDegrees(this.rhumblineAzimuth);
    }

    public double getGeodesicDistance() {
        if (this.isInvalid(16)) {
            this.computeDistance();
        }
        return this.geodesicDistance;
    }

    public void setGeodesicDistance(double d) {
        ArgumentChecks.ensurePositive("distance", d);
        this.geodesicDistance = d;
        this.setValid(16);
        this.validity &= 0xFFFFFFD5;
    }

    public double getRhumblineLength() {
        if (this.isInvalid(32)) {
            this.computeRhumbLine();
        }
        return this.rhumblineLength;
    }

    public Unit<Length> getDistanceUnit() {
        return this.ellipsoid.getAxisUnit();
    }

    double d\u03c6_dy(double d) {
        return Math.cos(d);
    }

    final void canComputeDistance() {
        if (this.isInvalid(3)) {
            throw new IllegalStateException(Resources.format((short)88, Integer.signum(this.validity & 1)));
        }
    }

    void computeRhumbLine() {
        double d;
        this.canComputeDistance();
        double d2 = Math.IEEEremainder(this.\u03bb2 - this.\u03bb1, Math.PI * 2);
        double d3 = this.\u03c62 - this.\u03c61;
        if (Math.abs(d3) < 1.5706706731410454E-10) {
            d = d2 * Math.cos((this.\u03c61 + this.\u03c62) / 2.0);
            this.rhumblineAzimuth = Math.copySign(1.5707963267948966, d2);
        } else {
            double d4 = Math.log(Math.tan(0.7853981633974483 + this.\u03c62 / 2.0) / Math.tan(0.7853981633974483 + this.\u03c61 / 2.0));
            d = d3 / d4 * Math.hypot(d2, d4);
            this.rhumblineAzimuth = Math.atan2(d2, d4);
        }
        this.rhumblineLength = this.semiMajorAxis * Math.abs(d);
        this.setValid(32);
    }

    void computeDistance() {
        this.canComputeDistance();
        double d = this.\u03bb2 - this.\u03bb1;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = Math.sin(this.\u03c61);
        double d5 = Math.cos(this.\u03c61);
        double d6 = Math.sin(this.\u03c62);
        double d7 = Math.cos(this.\u03c62);
        double d8 = d5 * d6;
        double d9 = d7 * d4;
        this.msin\u03b11 = d7 * d2;
        this.msin\u03b12 = d5 * d2;
        this.mcos\u03b11 = d8 - d9 * d3;
        this.mcos\u03b12 = d8 * d3 - d9;
        double d10 = d4 * d6 + d5 * d7 * d3;
        d10 = Math.atan2(Math.hypot(this.msin\u03b11, this.mcos\u03b11), d10);
        this.geodesicDistance = this.semiMajorAxis * d10;
        this.setValid(28);
    }

    final void canComputeEndPoint() {
        if (this.isInvalid(21)) {
            throw new IllegalStateException(this.isInvalid(1) ? Resources.format((short)88, 0) : Resources.format((short)87));
        }
    }

    void computeEndPoint() {
        this.canComputeEndPoint();
        double d = Math.hypot(this.msin\u03b11, this.mcos\u03b11);
        double d2 = this.geodesicDistance / this.semiMajorAxis;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.sin(this.\u03c61);
        double d6 = Math.cos(this.\u03c61);
        double d7 = this.msin\u03b11 / d;
        double d8 = this.mcos\u03b11 / d;
        double d9 = d3 * d8;
        double d10 = d3 * d7;
        double d11 = d4 * d6 - d5 * d9;
        double d12 = Math.atan2(d10, d11);
        double d13 = d5 * d4 + d6 * d9;
        this.\u03c62 = Math.atan(d13 / Math.hypot(d11, d10));
        this.\u03bb2 = Math.IEEEremainder(this.\u03bb1 + d12, Math.PI * 2);
        this.mcos\u03b12 = d4 * d8 - d5 / d6 * d3;
        this.msin\u03b12 = d7;
        this.setValid(10);
    }

    public void moveToEndPoint() {
        if (this.isInvalid(2)) {
            this.computeEndPoint();
        }
        this.\u03c61 = this.\u03c62;
        this.mcos\u03b11 = this.mcos\u03b12;
        this.\u03bb1 = this.\u03bb2;
        this.msin\u03b11 = this.msin\u03b12;
        this.validity = (this.validity & 8) >>> 1 | 1;
    }

    public Shape createGeodesicPath2D(double d) {
        Path2D path2D;
        ArgumentChecks.ensureStrictlyPositive("tolerance", d);
        if (this.isInvalid(31)) {
            if (this.isInvalid(2)) {
                this.computeEndPoint();
            } else {
                this.computeDistance();
            }
        }
        PathBuilder pathBuilder = new PathBuilder(d);
        try {
            path2D = pathBuilder.build();
        }
        catch (TransformException transformException) {
            throw new GeodeticException(this.transformError(true), transformException);
        }
        finally {
            pathBuilder.reset();
        }
        return ShapeUtilities.toPrimitive(path2D);
    }

    public Shape createGeodesicCircle2D(double d) {
        Path2D path2D;
        ArgumentChecks.ensureStrictlyPositive("tolerance", d);
        if (this.isInvalid(17)) {
            this.computeDistance();
        }
        CircularPath circularPath = new CircularPath(d);
        try {
            path2D = circularPath.build();
        }
        catch (TransformException transformException) {
            throw new GeodeticException(this.transformError(true), transformException);
        }
        finally {
            circularPath.reset();
        }
        path2D.closePath();
        return path2D;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Locale locale = Locale.getDefault();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        String string = System.lineSeparator();
        CoordinateReferenceSystem coordinateReferenceSystem = this.getPositionCRS();
        try {
            Object object;
            vocabulary.appendLabel((short)132, stringBuilder);
            stringBuilder.append(' ').append(coordinateReferenceSystem.getName().getCode()).append(string);
            if ((this.validity & 0xF) != 0) {
                boolean bl;
                object = ReferencingUtilities.getShortAxisNames(vocabulary, coordinateReferenceSystem);
                AngleFormat angleFormat = new AngleFormat("DD\u00b0MM\u2032SS\u2033", locale);
                CoordinateFormat coordinateFormat = new CoordinateFormat(locale, null);
                coordinateFormat.setSeparator("\t");
                coordinateFormat.setDefaultCRS(coordinateReferenceSystem);
                coordinateFormat.setPrecision(0.01, Units.METRE);
                TableAppender tableAppender = new TableAppender(stringBuilder, " \u2502 ");
                tableAppender.setCellAlignment((byte)0);
                tableAppender.appendHorizontalSeparator();
                for (String string2 : object) {
                    tableAppender.nextColumn();
                    tableAppender.append(string2);
                }
                tableAppender.nextColumn();
                tableAppender.append(vocabulary.getString((short)168)).nextLine();
                boolean bl2 = false;
                do {
                    tableAppender.setCellAlignment((byte)-1);
                    tableAppender.append(vocabulary.getString(bl ? (short)169 : 171)).nextColumn();
                    tableAppender.setCellAlignment((byte)1);
                    try {
                        coordinateFormat.format(bl ? this.getEndPoint() : this.getStartPoint(), (Appendable)tableAppender);
                        tableAppender.nextColumn();
                        tableAppender.append(angleFormat.format(bl ? this.getEndingAzimuth() : this.getStartingAzimuth()));
                    }
                    catch (IllegalStateException | GeodeticException numberFormat) {
                        // empty catch block
                    }
                    tableAppender.nextLine();
                } while (bl = !bl);
                tableAppender.appendHorizontalSeparator();
                tableAppender.flush();
            }
            try {
                object = this.getDistanceUnit();
                double d = this.getGeodesicDistance();
                double d2 = Units.METRE.getConverterTo((Unit<Length>)object).convert(0.01);
                NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                numberFormat.setMaximumFractionDigits(Numerics.fractionDigitsForDelta(d2));
                vocabulary.appendLabel((short)170, stringBuilder);
                stringBuilder.append(' ').append(numberFormat.format(d)).append(' ').append(object).append(string);
            }
            catch (IllegalStateException | GeodeticException runtimeException) {}
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }

    private final class CircularPath
    extends PathBuilder {
        private final double mcos\u03b1i;
        private final double msin\u03b1i;

        CircularPath(double d) {
            super(d);
            this.msin\u03b1i = GeodeticCalculator.this.msin\u03b11;
            this.mcos\u03b1i = GeodeticCalculator.this.mcos\u03b11;
            this.forceCubic = true;
        }

        @Override
        protected void evaluateAt(double d) throws TransformException {
            double d2 = d * (Math.PI * 2);
            GeodeticCalculator.this.msin\u03b11 = Math.sin(d2);
            GeodeticCalculator.this.mcos\u03b11 = Math.cos(d2);
            GeodeticCalculator.this.setValid(4);
            GeodeticCalculator.this.validity &= -65;
            GeodeticCalculator.this.computeEndPoint();
            this.evaluateAtEndPoint();
            if (this.depth <= 1) {
                this.\u03b5y = -1.0;
                this.\u03b5x = -1.0;
            }
            double d3 = this.dx;
            this.dx = this.dy;
            this.dy = -d3;
        }

        @Override
        void reset() {
            GeodeticCalculator.this.msin\u03b11 = this.msin\u03b1i;
            GeodeticCalculator.this.mcos\u03b11 = this.mcos\u03b1i;
            super.reset();
        }
    }

    private class PathBuilder
    extends Bezier {
        private final double mcos\u03b1f;
        private final double msin\u03b1f;
        private final double \u03c6f;
        private final double \u03bbf;
        private final double distance;
        private final double length;
        private final int flags;
        private final double tolerance;

        PathBuilder(double d) {
            super(ReferencingUtilities.getDimension(((GeodeticCalculator)GeodeticCalculator.this).userToGeodetic.defaultCRS));
            this.\u03c6f = GeodeticCalculator.this.\u03c62;
            this.\u03bbf = GeodeticCalculator.this.\u03bb2;
            this.msin\u03b1f = GeodeticCalculator.this.msin\u03b12;
            this.mcos\u03b1f = GeodeticCalculator.this.mcos\u03b12;
            this.tolerance = Math.toDegrees(d / GeodeticCalculator.this.semiMajorAxis);
            this.distance = GeodeticCalculator.this.geodesicDistance;
            this.length = GeodeticCalculator.this.rhumblineLength;
            this.flags = GeodeticCalculator.this.validity & 0x3F;
        }

        @Override
        protected void evaluateAt(double d) throws TransformException {
            if (d == 0.0) {
                GeodeticCalculator.this.\u03c62 = GeodeticCalculator.this.\u03c61;
                GeodeticCalculator.this.mcos\u03b12 = GeodeticCalculator.this.mcos\u03b11;
                GeodeticCalculator.this.\u03bb2 = GeodeticCalculator.this.\u03bb1;
                GeodeticCalculator.this.msin\u03b12 = GeodeticCalculator.this.msin\u03b11;
            } else if (d == 1.0) {
                GeodeticCalculator.this.\u03c62 = this.\u03c6f;
                GeodeticCalculator.this.mcos\u03b12 = this.mcos\u03b1f;
                GeodeticCalculator.this.\u03bb2 = this.\u03bbf;
                GeodeticCalculator.this.msin\u03b12 = this.msin\u03b1f;
            } else {
                GeodeticCalculator.this.geodesicDistance = this.distance * d;
                GeodeticCalculator.this.setValid(16);
                GeodeticCalculator.this.computeEndPoint();
            }
            this.evaluateAtEndPoint();
        }

        final void evaluateAtEndPoint() throws TransformException {
            if ((GeodeticCalculator.this.\u03bb2 - GeodeticCalculator.this.\u03bb1) * GeodeticCalculator.this.msin\u03b11 < 0.0) {
                GeodeticCalculator.this.\u03bb2 += Math.PI * 2 * Math.signum(GeodeticCalculator.this.msin\u03b11);
            }
            Matrix matrix = GeodeticCalculator.this.geographic(GeodeticCalculator.this.\u03c62, GeodeticCalculator.this.\u03bb2).inverseTransform(this.point);
            double d = GeodeticCalculator.this.d\u03c6_dy(GeodeticCalculator.this.\u03c62);
            double d2 = matrix.getElement(0, 0);
            double d3 = matrix.getElement(0, 1);
            double d4 = matrix.getElement(1, 0);
            double d5 = matrix.getElement(1, 1);
            double d6 = this.tolerance / d;
            this.\u03b5x = d2 * this.tolerance + d3 * d6;
            this.\u03b5y = d4 * this.tolerance + d5 * d6;
            d6 = GeodeticCalculator.this.mcos\u03b12 * d;
            this.dx = d2 * d6 + d3 * GeodeticCalculator.this.msin\u03b12;
            this.dy = d4 * d6 + d5 * GeodeticCalculator.this.msin\u03b12;
        }

        void reset() {
            GeodeticCalculator.this.\u03bb2 = this.\u03bbf;
            GeodeticCalculator.this.msin\u03b12 = this.msin\u03b1f;
            GeodeticCalculator.this.\u03c62 = this.\u03c6f;
            GeodeticCalculator.this.mcos\u03b12 = this.mcos\u03b1f;
            GeodeticCalculator.this.geodesicDistance = this.distance;
            GeodeticCalculator.this.rhumblineLength = this.length;
            GeodeticCalculator.this.validity = this.flags;
        }
    }
}

