/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix2
extends MatrixSIS {
    private static final long serialVersionUID = 7116561372481474290L;
    public static final int SIZE = 2;
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    Matrix2(boolean bl) {
    }

    public Matrix2(double d, double d2, double d3, double d4) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
    }

    public Matrix2(double[] dArray) throws IllegalArgumentException {
        this.setElements(dArray);
    }

    Matrix2(Matrix matrix) {
        this.m00 = matrix.getElement(0, 0);
        this.m01 = matrix.getElement(0, 1);
        this.m10 = matrix.getElement(1, 0);
        this.m11 = matrix.getElement(1, 1);
    }

    public static Matrix2 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix2) {
            return (Matrix2)matrix;
        }
        Matrix2.ensureSizeMatch(2, 2, matrix);
        return new Matrix2(matrix);
    }

    public final int getNumRow() {
        return 2;
    }

    public final int getNumCol() {
        return 2;
    }

    @Override
    public final double getElement(int n, int n2) {
        if (n >= 0 && n < 2 && n2 >= 0 && n2 < 2) {
            switch (n * 2 + n2) {
                case 0: {
                    return this.m00;
                }
                case 1: {
                    return this.m01;
                }
                case 2: {
                    return this.m10;
                }
                case 3: {
                    return this.m11;
                }
            }
        }
        throw Matrix2.indexOutOfBounds(n, n2);
    }

    public final void setElement(int n, int n2, double d) {
        if (n >= 0 && n < 2 && n2 >= 0 && n2 < 2) {
            switch (n * 2 + n2) {
                case 0: {
                    this.m00 = d;
                    return;
                }
                case 1: {
                    this.m01 = d;
                    return;
                }
                case 2: {
                    this.m10 = d;
                    return;
                }
                case 3: {
                    this.m11 = d;
                    return;
                }
            }
        }
        throw Matrix2.indexOutOfBounds(n, n2);
    }

    @Override
    public final double[] getElements() {
        double[] dArray = new double[4];
        this.getElements(dArray);
        return dArray;
    }

    @Override
    final void getElements(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m01;
        dArray[2] = this.m10;
        dArray[3] = this.m11;
    }

    @Override
    public final void setElements(double[] dArray) {
        Matrix2.ensureLengthMatch(4, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m10 = dArray[2];
        this.m11 = dArray[3];
    }

    @Override
    public final boolean isAffine() {
        return this.m10 == 0.0 && this.m11 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m10 == 0.0 && this.m01 == 0.0 && this.m11 == 1.0;
    }

    @Override
    public void transpose() {
        double d = this.m10;
        this.m10 = this.m01;
        this.m01 = d;
    }

    @Override
    public void normalizeColumns() {
        double d = Math.hypot(this.m00, this.m10);
        this.m00 /= d;
        this.m10 /= d;
        d = Math.hypot(this.m01, this.m11);
        this.m01 /= d;
        this.m11 /= d;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Matrix2) {
            Matrix2 matrix2 = (Matrix2)object;
            return Numerics.equals(this.m00, matrix2.m00) && Numerics.equals(this.m01, matrix2.m01) && Numerics.equals(this.m10, matrix2.m10) && Numerics.equals(this.m11, matrix2.m11);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(0x62C31ADCF5064EF2L ^ Double.doubleToLongBits(this.m00) + 31L * Double.doubleToLongBits(this.m01) + 31L * Double.doubleToLongBits(this.m10) + 31L * Double.doubleToLongBits(this.m11));
    }
}

