/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.Latitude;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.EqualAreaProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class AlbersEqualArea
extends EqualAreaProjection {
    private static final long serialVersionUID = -3024658742514888646L;
    final double nm;
    final double C;

    public AlbersEqualArea(OperationMethod operationMethod, Parameters parameters) {
        this(AlbersEqualArea.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.AlbersEqualArea.EASTING_AT_FALSE_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.AlbersEqualArea.NORTHING_AT_FALSE_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.AlbersEqualArea.LONGITUDE_OF_FALSE_ORIGIN);
        return new Initializer(operationMethod, parameters, enumMap, 0);
    }

    private AlbersEqualArea(Initializer initializer) {
        super(initializer);
        double d = initializer.getAndStore(org.apache.sis.internal.referencing.provider.AlbersEqualArea.LATITUDE_OF_FALSE_ORIGIN);
        double d2 = initializer.getAndStore(org.apache.sis.internal.referencing.provider.AlbersEqualArea.STANDARD_PARALLEL_1, d);
        double d3 = initializer.getAndStore(org.apache.sis.internal.referencing.provider.AlbersEqualArea.STANDARD_PARALLEL_2, d2);
        if (Math.abs(d2 + d3) < 8.999280057595393E-8) {
            throw new IllegalArgumentException(Resources.format((short)31, new Latitude(d2), new Latitude(d3)));
        }
        boolean bl = Math.abs(d2 - d3) >= 8.999280057595393E-8;
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        double d4 = Math.sin(d);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cos(d3);
        double d9 = initializer.scaleAt\u03c6(d5, d6);
        double d10 = this.qm(d5);
        if (bl) {
            double d11 = initializer.scaleAt\u03c6(d7, d8);
            double d12 = this.qm(d7);
            this.nm = (d9 * d9 - d11 * d11) / (d12 - d10);
        } else {
            this.nm = d5;
        }
        this.C = d9 * d9 + this.nm * d10;
        DoubleDouble doubleDouble = new DoubleDouble(1.0);
        doubleDouble.subtract(initializer.eccentricitySquared);
        doubleDouble.divide(this.nm);
        DoubleDouble doubleDouble2 = new DoubleDouble(this.C - this.nm * this.qm(d4));
        doubleDouble2.sqrt();
        doubleDouble2.multiply(doubleDouble);
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS2.convertBefore(0, doubleDouble, null);
        doubleDouble.negate();
        matrixSIS2.convertBefore(1, doubleDouble, doubleDouble2);
        doubleDouble.inverseDivide(-1.0);
        matrixSIS.convertAfter(0, doubleDouble, null);
    }

    AlbersEqualArea(AlbersEqualArea albersEqualArea) {
        super(albersEqualArea);
        this.nm = albersEqualArea.nm;
        this.C = albersEqualArea.C;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"n", "C"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.nm / (1.0 - this.eccentricitySquared), this.C};
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        AlbersEqualArea albersEqualArea = this;
        if (this.eccentricity == 0.0) {
            albersEqualArea = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, albersEqualArea);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.sin(d2);
        double d6 = Math.sqrt(this.C - this.nm * this.qm_ellipsoid(d5));
        if (dArray2 != null) {
            dArray2[n2] = d6 * d4;
            dArray2[n2 + 1] = d6 * d3;
        }
        if (!bl) {
            return null;
        }
        double d7 = 1.0 - this.eccentricitySquared;
        double d8 = -0.5 * this.nm * this.dqm_d\u03c6(d5, Math.cos(d2) * d7) / (d7 * d6);
        return new Matrix2(d3 * d6, d8 * d4, -d4 * d6, d8 * d3);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        dArray2[n2] = Math.atan2(d, d2);
        dArray2[n2 + 1] = this.\u03c6((this.C - (d * d + d2 * d2)) / this.nm);
    }

    static final class Spherical
    extends AlbersEqualArea {
        private static final long serialVersionUID = 9090765015127854096L;

        protected Spherical(AlbersEqualArea albersEqualArea) {
            super(albersEqualArea);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            double d5 = Math.sin(d2);
            double d6 = Math.sqrt(this.C - 2.0 * this.nm * d5);
            if (dArray2 != null) {
                dArray2[n2] = d6 * d4;
                dArray2[n2 + 1] = d6 * d3;
            }
            if (!bl) {
                return null;
            }
            double d7 = -this.nm * Math.cos(d2) / d6;
            return new Matrix2(d3 * d6, d7 * d4, -d4 * d6, d7 * d3);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            dArray2[n2] = Math.atan2(d, d2);
            dArray2[n2 + 1] = Math.asin((this.C - (d * d + d2 * d2)) / (this.nm * 2.0));
        }
    }
}

