/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonPointer;

public class PositionInfo {
    private final JsonPointer pointer;
    private final PositionEndpoint start;
    private final PositionEndpoint end;
    private String documentUrl = null;

    public PositionInfo(JsonPointer pointer, JsonLocation start, JsonLocation end) {
        this(pointer, new PositionEndpoint(start), new PositionEndpoint(end));
    }

    public PositionInfo(JsonPointer pointer, PositionEndpoint start, JsonLocation end) {
        this(pointer, start, new PositionEndpoint(end));
    }

    public PositionInfo(JsonPointer pointer, PositionEndpoint start, PositionEndpoint end) {
        this.pointer = pointer;
        this.start = start;
        this.end = end;
    }

    public JsonPointer getPointer() {
        return this.pointer;
    }

    public PositionEndpoint getStart() {
        return this.start;
    }

    public PositionEndpoint getEnd() {
        return this.end;
    }

    public String getDocumentUrl() {
        return this.documentUrl;
    }

    void setDocumentUrl(String documentUrl) {
        this.documentUrl = documentUrl;
    }

    public int getLine() {
        return this.start.getLine();
    }

    public int getColumn() {
        return this.start.getColumn();
    }

    public String toString() {
        return String.format("%s[%s-%s]", this.documentUrl, this.start, this.end);
    }

    public String toString(boolean startOnly) {
        return startOnly ? String.format("%s[%s]", this.documentUrl, this.start) : this.toString();
    }

    public static class PositionEndpoint {
        private final long charOffset;
        private final int line;
        private final int column;

        public PositionEndpoint(long charOffset, int line, int column) {
            this.charOffset = charOffset;
            this.line = line;
            this.column = column;
        }

        public PositionEndpoint(JsonLocation location) {
            this(location.getCharOffset(), location.getLineNr(), location.getColumnNr());
        }

        public long getCharOffset() {
            return this.charOffset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            return String.format("%d:%d", this.line, this.column);
        }
    }
}

