/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.encodings.geojson;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class GeoJSONValidator {
    public static final int GeoJSON = -1;
    public static final int EDRGeoJSON = -2;

    public boolean isGeoJSONValidPerSchema(String docURL, int schemaFlag) throws Exception {
        String schemaToApply = "/org/opengis/cite/ogcapiedr10/jsonschema/geojson.json";
        if (schemaFlag == -2) {
            schemaToApply = "/org/opengis/cite/ogcapiedr10/jsonschema/edrgeojson.json";
        }
        boolean valid = false;
        InputStream inputStream = this.getClass().getResourceAsStream(schemaToApply);
        JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
        Schema schema = SchemaLoader.load((JSONObject)rawSchema);
        schema.validate((Object)this.readJSONObjectFromURL(new URL(docURL)));
        valid = true;
        return valid;
    }

    public JSONObject readJSONObjectFromURL(URL requestURL) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)requestURL.openConnection();
        urlConnection.setRequestProperty("Accept", "application/json");
        InputStream is = urlConnection.getInputStream();
        try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            JSONObject jSONObject = new JSONObject(scanner.hasNext() ? scanner.next() : "");
            return jSONObject;
        }
    }
}

