/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.queries;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opengis.cite.ogcapiedr10.queries.AbstractProcessor;

public class CorridorQueryProcessor
extends AbstractProcessor {
    double sizeOfLensSide = 1.0;
    double corridorWidth = 2.0;
    String corridorWidthUnit = "m";
    public final String queryTypeNotSupported = "None of the collections support this query type. Increase the number of collections to parse.";

    public String validateCorridorQueryUsingParameters(Set<String> collectionIds, String rootUri, int noOfCollections, RequestSpecification ini) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> collectionsList = new ArrayList<String>();
        collectionsList.addAll(collectionIds);
        int numberOfCollectionsWithCorridorSupport = 0;
        for (int c = 0; c < Math.min(noOfCollections, collectionsList.size()); ++c) {
            String collectionId = (String)collectionsList.get(c);
            boolean supportsCorridorQuery = false;
            String url = rootUri.toString() + "/collections/" + collectionId;
            Response response = (Response)ini.baseUri(url).accept(ContentType.JSON).when().request(Method.GET);
            JsonPath jsonResponse = response.jsonPath();
            HashMap dataQueries = (HashMap)jsonResponse.getJsonObject("data_queries");
            supportsCorridorQuery = dataQueries.containsKey("corridor");
            if (!supportsCorridorQuery) continue;
            ++numberOfCollectionsWithCorridorSupport;
            HashMap parameterNames = (HashMap)jsonResponse.getJsonObject("parameter_names");
            Set parameterNamesSet = parameterNames.keySet();
            Iterator parameterNamesIterator = parameterNamesSet.iterator();
            parameterNamesIterator.hasNext();
            String sampleParamaterName = (String)parameterNamesIterator.next();
            List crsList = jsonResponse.getList("crs");
            String supportedCRS = null;
            for (int q = 0; q < crsList.size(); ++q) {
                if (!((String)crsList.get(q)).equals("CRS:84") && !((String)crsList.get(q)).equals("CRS84") && !((String)crsList.get(q)).equals("EPSG:4326") && !((String)crsList.get(q)).equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84")) continue;
                supportedCRS = (String)crsList.get(q);
            }
            if (supportedCRS == null) {
                sb.append(collectionId + " does not support CRS84 CRS. \n");
            }
            HashMap corridorQuery = (HashMap)dataQueries.get("corridor");
            HashMap link = (HashMap)corridorQuery.get("link");
            HashMap variables = (HashMap)link.get("variables");
            ArrayList outputFormatList = (ArrayList)variables.get("output_formats");
            String supportedFormat = null;
            for (int f = 0; f < outputFormatList.size(); ++f) {
                if (((String)outputFormatList.get(f)).equals("CoverageJSON") || ((String)outputFormatList.get(f)).contains("CoverageJSON")) {
                    supportedFormat = (String)outputFormatList.get(f);
                    continue;
                }
                if (!((String)outputFormatList.get(f)).equals("GeoJSON")) continue;
                supportedFormat = (String)outputFormatList.get(f);
            }
            double medianx = 0.0;
            double mediany = 0.0;
            double lminx = 0.0;
            double lminy = 0.0;
            double lmaxx = 0.0;
            double lmaxy = 0.0;
            HashMap extent = (HashMap)jsonResponse.getJsonObject("extent");
            if (extent.containsKey("spatial")) {
                HashMap spatial = (HashMap)extent.get("spatial");
                if (!spatial.containsKey("bbox")) {
                    sb.append("spatial extent of collection " + collectionId + " missing bbox. \n");
                    continue;
                }
                ArrayList bboxEnv = (ArrayList)spatial.get("bbox");
                ArrayList bbox = null;
                if (bboxEnv.get(0).getClass().toString().contains("java.lang.Integer") || bboxEnv.get(0).getClass().toString().contains("java.lang.Double") || bboxEnv.get(0).getClass().toString().contains("java.lang.Float")) {
                    bbox = bboxEnv;
                } else if (bboxEnv.get(0).getClass().toString().contains("java.util.ArrayList")) {
                    bbox = (ArrayList)bboxEnv.get(0);
                }
                if (bbox.size() > 3) {
                    if (bbox.get(0).getClass().toString().contains("Integer") || bbox.get(0).getClass().toString().contains("Double") || bbox.get(0).getClass().toString().contains("Float")) {
                        double minx = Double.parseDouble(bbox.get(0).toString());
                        double miny = Double.parseDouble(bbox.get(1).toString());
                        double maxx = Double.parseDouble(bbox.get(2).toString());
                        double maxy = Double.parseDouble(bbox.get(3).toString());
                        medianx = minx + (maxx - minx) / 2.0;
                        mediany = miny + (maxy - miny) / 2.0;
                        lminx = medianx - this.sizeOfLensSide;
                        lminy = mediany - this.sizeOfLensSide;
                        lmaxx = medianx + this.sizeOfLensSide;
                        lmaxy = mediany + this.sizeOfLensSide;
                    }
                } else {
                    sb.append("bbox of spatial extent of collection" + collectionId + " has fewer than four coordinates. \n");
                }
            }
            String sampleParamaterNameSafe = null;
            try {
                sampleParamaterNameSafe = URLEncoder.encode(sampleParamaterName, "UTF8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String sampleDateTime = null;
            if (extent.containsKey("temporal")) {
                HashMap temporal = (HashMap)extent.get("temporal");
                if (!temporal.containsKey("interval")) {
                    sb.append("Temporal extent of collection " + collectionId + " missing interval. \n");
                    continue;
                }
                ArrayList intervalEnv = (ArrayList)temporal.get("interval");
                ArrayList interval = null;
                if (intervalEnv.get(0).getClass().toString().contains("java.lang.String")) {
                    interval = intervalEnv;
                } else if (intervalEnv.get(0).getClass().toString().contains("java.util.ArrayList")) {
                    interval = (ArrayList)intervalEnv.get(0);
                }
                if (interval.size() > 1) {
                    sampleDateTime = interval.get(0) + "/" + interval.get(1);
                }
            }
            String constructedURL = url + "/corridor?parameter-name=" + sampleParamaterNameSafe + "&coords=LINESTRING(" + lminx + "+" + lminy + "," + medianx + "+" + mediany + "," + lmaxx + "+" + lmaxy + ")&corridor-width=" + this.corridorWidth + "&width-units=" + this.corridorWidthUnit + "&f=" + supportedFormat + "&datetime=" + sampleDateTime;
            System.out.println("C " + constructedURL);
            String pageContent = null;
            try {
                pageContent = this.readStringFromURL(constructedURL, 10);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (pageContent != null) {
                if (pageContent.contains("Coverage") || pageContent.contains("Feature")) continue;
                sb.append("Response of Corridor Query on collection " + collectionId + " did not contain a recognised encoding. \n");
                continue;
            }
            sb.append("Response of Corridor Query on collection " + collectionId + " was null. \n");
        }
        if (numberOfCollectionsWithCorridorSupport == 0) {
            sb.append("None of the collections support this query type. Increase the number of collections to parse.\n");
        }
        return sb.toString();
    }
}

