/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.encodings.geojson;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.encodings.geojson.GeoJSONValidator;
import org.testng.annotations.Test;

public class GeoJSONEncoding
extends CommonFixture {
    protected URI iut;

    @Test(description="Implements Abstract Test 20 (/conf/geojson/definition), Abstract Test 21 (/conf/geojson/content)")
    public void validateResponseForGeoJSON() {
        StringBuffer sb = new StringBuffer();
        boolean atLeastOneCollectionTested = false;
        Response response = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        JsonPath jsonResponse = response.jsonPath();
        ArrayList collectionsList = (ArrayList)jsonResponse.getList("collections");
        for (int i = 0; i < collectionsList.size() && !atLeastOneCollectionTested; ++i) {
            HashMap collectionItem = (HashMap)collectionsList.get(i);
            HashMap dataQueries = (HashMap)collectionItem.get("data_queries");
            boolean supportsLocationsQuery = dataQueries.containsKey("locations");
            if (supportsLocationsQuery) {
                HashMap locationsQuery = (HashMap)dataQueries.get("locations");
                HashMap link = (HashMap)locationsQuery.get("link");
                HashMap variables = (HashMap)link.get("variables");
                ArrayList outputFormatList = (ArrayList)variables.get("output_formats");
                String supportedFormat = null;
                for (int f = 0; f < outputFormatList.size(); ++f) {
                    if (!((String)outputFormatList.get(f)).equals("GeoJSON")) continue;
                    supportedFormat = (String)outputFormatList.get(f);
                }
                try {
                    if (supportedFormat != null) {
                        String locationsURL = link.get("href").toString() + "?f=" + supportedFormat;
                        GeoJSONValidator validator = new GeoJSONValidator();
                        boolean result = validator.isGeoJSONValidPerSchema(locationsURL, -1);
                        atLeastOneCollectionTested = true;
                        if (result) continue;
                        sb.append(" None of the collections with locations resources were found to offer GeoJSON encoded responses.\n");
                        continue;
                    }
                    sb.append(" None of the collections with locations resources were found to offer GeoJSON encoded responses.\n");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    sb.append(" " + ex.getMessage() + "\n");
                }
                continue;
            }
            sb.append(" None of the collections were found to offer locations resources.\n");
        }
        String resultMessage = sb.toString();
        EtsAssert.assertTrue(resultMessage.length() == 0, "Fails Abstract Test 21. " + resultMessage);
    }
}

