/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.Classes;

public class Polynom
implements Serializable {
    private static final long serialVersionUID = 6825019711186108990L;
    private final double[] c;
    private transient double[] roots;

    public Polynom(double[] dArray) {
        int n = dArray.length;
        while (n != 0 && dArray[--n] == 0.0) {
        }
        if (n == 0) {
            this.c = XArrays.EMPTY_DOUBLE;
        } else {
            this.c = new double[n];
            System.arraycopy(dArray, 0, this.c, 0, n);
        }
    }

    public final double y(double d) {
        double d2 = 0.0;
        int n = this.c.length;
        while (--n >= 0) {
            d2 = d2 * d + this.c[n];
        }
        return d2;
    }

    private static double[] quadraticRoots(double d, double d2, double d3) {
        double d4 = d2 * d2 - 4.0 * d3 * d;
        if (d4 > 0.0) {
            d4 = Math.sqrt(d4);
            if (d2 < 0.0) {
                d4 = -d4;
            }
            double d5 = 0.5 * (d4 - d2);
            return new double[]{d5 / d3, d5 != 0.0 ? d / d5 : -0.5 * (d4 + d2) / d3};
        }
        if (d4 == 0.0) {
            return new double[]{-d2 / (2.0 * d3)};
        }
        return XArrays.EMPTY_DOUBLE;
    }

    private static double[] cubicRoots(double d, double d2, double d3, double d4) {
        double d5 = ((d3 /= d4) * d3 - 3.0 * (d2 /= d4)) / 9.0;
        double d6 = (2.0 * d3 * d3 * d3 - 9.0 * d3 * d2 + 27.0 * (d /= d4)) / 54.0;
        double d7 = d5 * d5 * d5;
        double d8 = d7 - d6 * d6;
        d3 /= 3.0;
        if (d8 >= 0.0) {
            double d9 = Math.acos(d6 / Math.sqrt(d7)) / 3.0;
            double d10 = -2.0 * Math.sqrt(d5);
            double[] dArray = new double[]{d10 * Math.cos(d9) - d3, d10 * Math.cos(d9 + 2.0943951023931953) - d3, d10 * Math.cos(d9 + 4.1887902047863905) - d3};
            assert (Math.abs(dArray[0] * dArray[1] * dArray[2] + d) < 1.0E-6);
            assert (Math.abs(dArray[0] + dArray[1] + dArray[2] + d3 * 3.0) < 1.0E-6);
            assert (Math.abs(dArray[0] * dArray[1] + dArray[0] * dArray[2] + dArray[1] * dArray[2] - d2) < 1.0E-6);
            return dArray;
        }
        double d11 = Math.cbrt(Math.sqrt(-d8) + Math.abs(d6));
        if (d6 > 0.0) {
            d11 = -d11;
        }
        return new double[]{d11 + d5 / d11 - d3};
    }

    public double[] roots() {
        if (this.roots == null) {
            this.roots = Polynom.roots(this.c);
        }
        return (double[])this.roots.clone();
    }

    public static double[] roots(double[] dArray) {
        int n = dArray.length;
        while (n != 0 && dArray[--n] == 0.0) {
        }
        switch (n) {
            case 0: {
                return XArrays.EMPTY_DOUBLE;
            }
            case 1: {
                return new double[]{-dArray[0] / dArray[1]};
            }
            case 2: {
                return Polynom.quadraticRoots(dArray[0], dArray[1], dArray[2]);
            }
            case 3: {
                return Polynom.cubicRoots(dArray[0], dArray[1], dArray[2], dArray[3]);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(n));
    }

    public int hashCode() {
        return Arrays.hashCode(this.c) ^ 0x4E49823E;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Polynom polynom = (Polynom)object;
            return Arrays.equals(this.c, polynom.c);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this));
        stringBuilder.append('[');
        for (int i = 0; i < this.c.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.c[i]);
        }
        return stringBuilder.append(']').toString();
    }
}

