/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.UniqueCoordinateArrayFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private GeometryFactory geomFactory;
    private Coordinate[] inputPts;

    public ConvexHull(Geometry geometry) {
        this(ConvexHull.extractCoordinates(geometry), geometry.getFactory());
    }

    public ConvexHull(Coordinate[] pts, GeometryFactory geomFactory) {
        this.inputPts = pts;
        this.geomFactory = geomFactory;
    }

    private static Coordinate[] extractCoordinates(Geometry geom) {
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        geom.apply(filter);
        return filter.getCoordinates();
    }

    public Geometry getConvexHull() {
        if (this.inputPts.length == 0) {
            return this.geomFactory.createGeometryCollection(null);
        }
        if (this.inputPts.length == 1) {
            return this.geomFactory.createPoint(this.inputPts[0]);
        }
        if (this.inputPts.length == 2) {
            return this.geomFactory.createLineString(this.inputPts);
        }
        Coordinate[] reducedPts = this.inputPts;
        if (this.inputPts.length > 50) {
            reducedPts = this.reduce(this.inputPts);
        }
        Coordinate[] sortedPts = this.preSort(reducedPts);
        Stack cHS = this.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinates = new Coordinate[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            Coordinate coordinate;
            coordinates[i] = coordinate = (Coordinate)stack.get(i);
        }
        return coordinates;
    }

    private Coordinate[] reduce(Coordinate[] inputPts) {
        int i;
        Coordinate[] polyPts = this.computeOctRing(inputPts);
        if (polyPts == null) {
            return inputPts;
        }
        TreeSet<Coordinate> reducedSet = new TreeSet<Coordinate>();
        for (i = 0; i < polyPts.length; ++i) {
            reducedSet.add(polyPts[i]);
        }
        for (i = 0; i < inputPts.length; ++i) {
            if (CGAlgorithms.isPointInRing(inputPts[i], polyPts)) continue;
            reducedSet.add(inputPts[i]);
        }
        Coordinate[] reducedPts = CoordinateArrays.toCoordinateArray(reducedSet);
        return reducedPts;
    }

    private Coordinate[] preSort(Coordinate[] pts) {
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].y < pts[0].y) && (pts[i].y != pts[0].y || !(pts[i].x < pts[0].x))) continue;
            Coordinate t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        Arrays.sort(pts, 1, pts.length, new RadialComparator(pts[0]));
        return pts;
    }

    private Stack grahamScan(Coordinate[] c) {
        Stack<Coordinate> ps = new Stack<Coordinate>();
        Coordinate p = ps.push(c[0]);
        p = ps.push(c[1]);
        p = ps.push(c[2]);
        for (int i = 3; i < c.length; ++i) {
            p = (Coordinate)ps.pop();
            while (CGAlgorithms.computeOrientation((Coordinate)ps.peek(), p, c[i]) > 0) {
                p = (Coordinate)ps.pop();
            }
            p = ps.push(p);
            p = ps.push(c[i]);
        }
        p = ps.push(c[0]);
        return ps;
    }

    private boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (CGAlgorithms.computeOrientation(c1, c2, c3) != 0) {
            return false;
        }
        if (c1.x != c3.x) {
            if (c1.x <= c2.x && c2.x <= c3.x) {
                return true;
            }
            if (c3.x <= c2.x && c2.x <= c1.x) {
                return true;
            }
        }
        if (c1.y != c3.y) {
            if (c1.y <= c2.y && c2.y <= c3.y) {
                return true;
            }
            if (c3.y <= c2.y && c2.y <= c1.y) {
                return true;
            }
        }
        return false;
    }

    private Coordinate[] computeOctRing(Coordinate[] inputPts) {
        Coordinate[] octPts = this.computeOctPts(inputPts);
        CoordinateList coordList = new CoordinateList();
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private Coordinate[] computeOctPts(Coordinate[] inputPts) {
        Coordinate[] pts = new Coordinate[8];
        for (int j = 0; j < pts.length; ++j) {
            pts[j] = inputPts[0];
        }
        for (int i = 1; i < inputPts.length; ++i) {
            if (inputPts[i].x < pts[0].x) {
                pts[0] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y < pts[1].x - pts[1].y) {
                pts[1] = inputPts[i];
            }
            if (inputPts[i].y > pts[2].y) {
                pts[2] = inputPts[i];
            }
            if (inputPts[i].x + inputPts[i].y > pts[3].x + pts[3].y) {
                pts[3] = inputPts[i];
            }
            if (inputPts[i].x > pts[4].x) {
                pts[4] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y > pts[5].x - pts[5].y) {
                pts[5] = inputPts[i];
            }
            if (inputPts[i].y < pts[6].y) {
                pts[6] = inputPts[i];
            }
            if (!(inputPts[i].x + inputPts[i].y < pts[7].x + pts[7].y)) continue;
            pts[7] = inputPts[i];
        }
        return pts;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinates) {
        if ((coordinates = this.cleanRing(coordinates)).length == 3) {
            return this.geomFactory.createLineString(new Coordinate[]{coordinates[0], coordinates[1]});
        }
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinates);
        return this.geomFactory.createPolygon(linearRing, null);
    }

    private Coordinate[] cleanRing(Coordinate[] original) {
        Assert.equals(original[0], original[original.length - 1]);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        for (int i = 0; i <= original.length - 2; ++i) {
            Coordinate currentCoordinate = original[i];
            Coordinate nextCoordinate = original[i + 1];
            if (currentCoordinate.equals(nextCoordinate) || previousDistinctCoordinate != null && this.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate)) continue;
            cleanedRing.add(currentCoordinate);
            previousDistinctCoordinate = currentCoordinate;
        }
        cleanedRing.add(original[original.length - 1]);
        Coordinate[] cleanedRingCoordinates = new Coordinate[cleanedRing.size()];
        return cleanedRing.toArray(cleanedRingCoordinates);
    }

    private static class RadialComparator
    implements Comparator {
        private Coordinate origin;

        public RadialComparator(Coordinate origin) {
            this.origin = origin;
        }

        public int compare(Object o1, Object o2) {
            Coordinate p1 = (Coordinate)o1;
            Coordinate p2 = (Coordinate)o2;
            return RadialComparator.polarCompare(this.origin, p1, p2);
        }

        private static int polarCompare(Coordinate o, Coordinate p, Coordinate q) {
            double dxp = p.x - o.x;
            double dyp = p.y - o.y;
            double dxq = q.x - o.x;
            double dyq = q.y - o.y;
            int orient = CGAlgorithms.computeOrientation(o, p, q);
            if (orient == 1) {
                return 1;
            }
            if (orient == -1) {
                return -1;
            }
            double op = dxp * dxp + dyp * dyp;
            double oq = dxq * dxq + dyq * dyq;
            if (op < oq) {
                return -1;
            }
            if (op > oq) {
                return 1;
            }
            return 0;
        }
    }
}

