/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.wkt.ReferencingParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.lang.Buffered;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultDerivedCRS;
import org.geotoolkit.referencing.crs.DefaultEngineeringCRS;
import org.geotoolkit.referencing.crs.DefaultGeocentricCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultImageCRS;
import org.geotoolkit.referencing.crs.DefaultProjectedCRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.cs.DefaultAffineCS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultCylindricalCS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.cs.DefaultLinearCS;
import org.geotoolkit.referencing.cs.DefaultPolarCS;
import org.geotoolkit.referencing.cs.DefaultSphericalCS;
import org.geotoolkit.referencing.cs.DefaultTimeCS;
import org.geotoolkit.referencing.cs.DefaultUserDefinedCS;
import org.geotoolkit.referencing.cs.DefaultVerticalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultEngineeringDatum;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.datum.DefaultImageDatum;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.datum.DefaultTemporalDatum;
import org.geotoolkit.referencing.datum.DefaultVerticalDatum;
import org.geotoolkit.referencing.factory.DatumAliases;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.operation.DefaultMathTransformFactory;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@Buffered
@ThreadSafe
public class ReferencingObjectFactory
extends ReferencingFactory
implements CSFactory,
DatumFactory,
CRSFactory {
    private volatile MathTransformFactory mtFactory;
    private DatumFactory datumFactory;
    private final ThreadLocal<ReferencingParser> parser;
    private final WeakHashSet<IdentifiedObject> pool = WeakHashSet.newInstance(IdentifiedObject.class);

    public ReferencingObjectFactory() {
        this(EMPTY_HINTS);
    }

    public ReferencingObjectFactory(Hints hints) {
        this.parser = new ThreadLocal();
        if (!XCollections.isNullOrEmpty((Map)hints)) {
            this.mtFactory = FactoryFinder.getMathTransformFactory((Hints)hints);
        }
    }

    private synchronized DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = this;
            for (DatumFactory datumFactory : FactoryFinder.getDatumFactories((Hints)EMPTY_HINTS)) {
                if (!(datumFactory instanceof DatumAliases) || ((DatumAliases)datumFactory).getDatumFactory() != this) continue;
                this.datumFactory = datumFactory;
                break;
            }
        }
        return this.datumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MathTransformFactory getMathTransformFactory() {
        MathTransformFactory mathTransformFactory = this.mtFactory;
        if (mathTransformFactory == null) {
            MathTransformFactory mathTransformFactory2 = FactoryFinder.getMathTransformFactory((Hints)EMPTY_HINTS);
            ReferencingObjectFactory referencingObjectFactory = this;
            synchronized (referencingObjectFactory) {
                mathTransformFactory = this.mtFactory;
                if (mathTransformFactory == null) {
                    this.mtFactory = mathTransformFactory = mathTransformFactory2;
                    this.hints.put(Hints.MATH_TRANSFORM_FACTORY, mathTransformFactory);
                }
            }
        }
        return mathTransformFactory;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        this.getMathTransformFactory();
        return super.getImplementationHints();
    }

    @Override
    public Ellipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createEllipsoid(map, d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoid = (Ellipsoid)this.pool.unique((Object)ellipsoid);
        return ellipsoid;
    }

    @Override
    public Ellipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createFlattenedSphere(map, d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoid = (Ellipsoid)this.pool.unique((Object)ellipsoid);
        return ellipsoid;
    }

    @Override
    public PrimeMeridian createPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) throws FactoryException {
        PrimeMeridian primeMeridian;
        try {
            primeMeridian = new DefaultPrimeMeridian(map, d, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        primeMeridian = (PrimeMeridian)this.pool.unique((Object)primeMeridian);
        return primeMeridian;
    }

    @Override
    public GeodeticDatum createGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        GeodeticDatum geodeticDatum;
        try {
            geodeticDatum = new DefaultGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geodeticDatum = (GeodeticDatum)this.pool.unique((Object)geodeticDatum);
        return geodeticDatum;
    }

    @Override
    public VerticalDatum createVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) throws FactoryException {
        VerticalDatum verticalDatum;
        try {
            verticalDatum = new DefaultVerticalDatum(map, verticalDatumType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        verticalDatum = (VerticalDatum)this.pool.unique((Object)verticalDatum);
        return verticalDatum;
    }

    @Override
    public TemporalDatum createTemporalDatum(Map<String, ?> map, Date date) throws FactoryException {
        TemporalDatum temporalDatum;
        try {
            temporalDatum = new DefaultTemporalDatum(map, date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        temporalDatum = (TemporalDatum)this.pool.unique((Object)temporalDatum);
        return temporalDatum;
    }

    @Override
    public EngineeringDatum createEngineeringDatum(Map<String, ?> map) throws FactoryException {
        EngineeringDatum engineeringDatum;
        try {
            engineeringDatum = new DefaultEngineeringDatum(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        engineeringDatum = (EngineeringDatum)this.pool.unique((Object)engineeringDatum);
        return engineeringDatum;
    }

    @Override
    public ImageDatum createImageDatum(Map<String, ?> map, PixelInCell pixelInCell) throws FactoryException {
        ImageDatum imageDatum;
        try {
            imageDatum = new DefaultImageDatum(map, pixelInCell);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        imageDatum = (ImageDatum)this.pool.unique((Object)imageDatum);
        return imageDatum;
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) throws FactoryException {
        CoordinateSystemAxis coordinateSystemAxis;
        try {
            coordinateSystemAxis = new DefaultCoordinateSystemAxis(map, string, axisDirection, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        coordinateSystemAxis = (CoordinateSystemAxis)this.pool.unique((Object)coordinateSystemAxis);
        return coordinateSystemAxis;
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        CartesianCS cartesianCS;
        try {
            cartesianCS = new DefaultCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        cartesianCS = (CartesianCS)this.pool.unique((Object)cartesianCS);
        return cartesianCS;
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        CartesianCS cartesianCS;
        try {
            cartesianCS = new DefaultCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        cartesianCS = (CartesianCS)this.pool.unique((Object)cartesianCS);
        return cartesianCS;
    }

    @Override
    public AffineCS createAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        AffineCS affineCS;
        try {
            affineCS = new DefaultAffineCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        affineCS = (AffineCS)this.pool.unique((Object)affineCS);
        return affineCS;
    }

    @Override
    public AffineCS createAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        AffineCS affineCS;
        try {
            affineCS = new DefaultAffineCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        affineCS = (AffineCS)this.pool.unique((Object)affineCS);
        return affineCS;
    }

    @Override
    public PolarCS createPolarCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        PolarCS polarCS;
        try {
            polarCS = new DefaultPolarCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        polarCS = (PolarCS)this.pool.unique((Object)polarCS);
        return polarCS;
    }

    @Override
    public CylindricalCS createCylindricalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        CylindricalCS cylindricalCS;
        try {
            cylindricalCS = new DefaultCylindricalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        cylindricalCS = (CylindricalCS)this.pool.unique((Object)cylindricalCS);
        return cylindricalCS;
    }

    @Override
    public SphericalCS createSphericalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        SphericalCS sphericalCS;
        try {
            sphericalCS = new DefaultSphericalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        sphericalCS = (SphericalCS)this.pool.unique((Object)sphericalCS);
        return sphericalCS;
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        EllipsoidalCS ellipsoidalCS;
        try {
            ellipsoidalCS = new DefaultEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoidalCS = (EllipsoidalCS)this.pool.unique((Object)ellipsoidalCS);
        return ellipsoidalCS;
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        EllipsoidalCS ellipsoidalCS;
        try {
            ellipsoidalCS = new DefaultEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoidalCS = (EllipsoidalCS)this.pool.unique((Object)ellipsoidalCS);
        return ellipsoidalCS;
    }

    @Override
    public VerticalCS createVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        VerticalCS verticalCS;
        try {
            verticalCS = new DefaultVerticalCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        verticalCS = (VerticalCS)this.pool.unique((Object)verticalCS);
        return verticalCS;
    }

    @Override
    public TimeCS createTimeCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        TimeCS timeCS;
        try {
            timeCS = new DefaultTimeCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        timeCS = (TimeCS)this.pool.unique((Object)timeCS);
        return timeCS;
    }

    @Override
    public LinearCS createLinearCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        LinearCS linearCS;
        try {
            linearCS = new DefaultLinearCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        linearCS = (LinearCS)this.pool.unique((Object)linearCS);
        return linearCS;
    }

    @Override
    public UserDefinedCS createUserDefinedCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        UserDefinedCS userDefinedCS;
        try {
            userDefinedCS = new DefaultUserDefinedCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        userDefinedCS = (UserDefinedCS)this.pool.unique((Object)userDefinedCS);
        return userDefinedCS;
    }

    @Override
    public UserDefinedCS createUserDefinedCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        UserDefinedCS userDefinedCS;
        try {
            userDefinedCS = new DefaultUserDefinedCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        userDefinedCS = (UserDefinedCS)this.pool.unique((Object)userDefinedCS);
        return userDefinedCS;
    }

    @Override
    public CompoundCRS createCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        CompoundCRS compoundCRS;
        try {
            compoundCRS = new DefaultCompoundCRS(map, coordinateReferenceSystemArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        compoundCRS = (CompoundCRS)this.pool.unique((Object)compoundCRS);
        return compoundCRS;
    }

    @Override
    public EngineeringCRS createEngineeringCRS(Map<String, ?> map, EngineeringDatum engineeringDatum, CoordinateSystem coordinateSystem) throws FactoryException {
        EngineeringCRS engineeringCRS;
        try {
            engineeringCRS = new DefaultEngineeringCRS(map, engineeringDatum, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        engineeringCRS = (EngineeringCRS)this.pool.unique((Object)engineeringCRS);
        return engineeringCRS;
    }

    @Override
    public ImageCRS createImageCRS(Map<String, ?> map, ImageDatum imageDatum, AffineCS affineCS) throws FactoryException {
        ImageCRS imageCRS;
        try {
            imageCRS = new DefaultImageCRS(map, imageDatum, affineCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        imageCRS = (ImageCRS)this.pool.unique((Object)imageCRS);
        return imageCRS;
    }

    @Override
    public TemporalCRS createTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) throws FactoryException {
        TemporalCRS temporalCRS;
        try {
            temporalCRS = new DefaultTemporalCRS(map, temporalDatum, timeCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        temporalCRS = (TemporalCRS)this.pool.unique((Object)temporalCRS);
        return temporalCRS;
    }

    @Override
    public VerticalCRS createVerticalCRS(Map<String, ?> map, VerticalDatum verticalDatum, VerticalCS verticalCS) throws FactoryException {
        VerticalCRS verticalCRS;
        try {
            verticalCRS = new DefaultVerticalCRS(map, verticalDatum, verticalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        verticalCRS = (VerticalCRS)this.pool.unique((Object)verticalCRS);
        return verticalCRS;
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CartesianCS cartesianCS) throws FactoryException {
        GeocentricCRS geocentricCRS;
        try {
            geocentricCRS = new DefaultGeocentricCRS(map, geodeticDatum, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geocentricCRS = (GeocentricCRS)this.pool.unique((Object)geocentricCRS);
        return geocentricCRS;
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, SphericalCS sphericalCS) throws FactoryException {
        GeocentricCRS geocentricCRS;
        try {
            geocentricCRS = new DefaultGeocentricCRS(map, geodeticDatum, sphericalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geocentricCRS = (GeocentricCRS)this.pool.unique((Object)geocentricCRS);
        return geocentricCRS;
    }

    @Override
    public GeographicCRS createGeographicCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) throws FactoryException {
        GeographicCRS geographicCRS;
        try {
            geographicCRS = new DefaultGeographicCRS(map, geodeticDatum, ellipsoidalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geographicCRS = (GeographicCRS)this.pool.unique((Object)geographicCRS);
        return geographicCRS;
    }

    @Override
    public DerivedCRS createDerivedCRS(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, Conversion conversion, CoordinateSystem coordinateSystem) throws FactoryException {
        Object object;
        MathTransform mathTransform = conversion.getMathTransform();
        if (mathTransform == null) {
            object = conversion.getParameterValues();
            MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
            mathTransform = mathTransformFactory.createParameterizedTransform((ParameterValueGroup)object);
        }
        try {
            object = new DefaultDerivedCRS(map, conversion, coordinateReferenceSystem, mathTransform, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        object = (DerivedCRS)this.pool.unique(object);
        return object;
    }

    @Override
    public ProjectedCRS createProjectedCRS(Map<String, ?> map, GeographicCRS geographicCRS, Conversion conversion, CartesianCS cartesianCS) throws FactoryException {
        Object object;
        MathTransform mathTransform;
        MathTransform mathTransform2 = conversion.getMathTransform();
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransform2 != null && mathTransformFactory instanceof DefaultMathTransformFactory) {
            mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createBaseToDerived((CoordinateReferenceSystem)geographicCRS, mathTransform2, (CoordinateSystem)cartesianCS);
        } else {
            object = conversion.getParameterValues();
            mathTransform = mathTransformFactory.createBaseToDerived(geographicCRS, (ParameterValueGroup)object, cartesianCS);
            OperationMethod operationMethod = conversion.getMethod();
            if (!(operationMethod instanceof MathTransformProvider) && !map.containsKey("conversionType") && (operationMethod = mathTransformFactory.getLastMethodUsed()) instanceof MathTransformProvider) {
                HashMap hashMap = new HashMap(map);
                hashMap.put("conversionType", ((MathTransformProvider)operationMethod).getOperationType());
                map = hashMap;
            }
            if (mathTransform2 != null && mathTransform2.equals(mathTransform)) {
                mathTransform = mathTransform2;
            }
        }
        try {
            object = new DefaultProjectedCRS(map, conversion, geographicCRS, mathTransform, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        object = (ProjectedCRS)this.pool.unique(object);
        return object;
    }

    @Override
    public CoordinateReferenceSystem createFromXML(String string) throws FactoryException {
        throw new FactoryException("Not yet implemented");
    }

    @Override
    public CoordinateReferenceSystem createFromWKT(String string) throws FactoryException {
        ReferencingParser referencingParser = this.parser.get();
        if (referencingParser == null) {
            referencingParser = new ReferencingParser(Symbols.DEFAULT, this.getDatumFactory(), this, this, this.getMathTransformFactory());
            referencingParser.setISOConform(true);
            this.parser.set(referencingParser);
        }
        try {
            return referencingParser.parseCoordinateReferenceSystem(string);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException(parseException);
        }
    }
}

