/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.conformance;

import com.reprezen.kaizen.oasparser.OpenApiParser;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ApiDefinition
extends CommonFixture {
    private String response;
    private String apiUrl;

    @BeforeClass(dependsOnMethods={"initCommonFixture"})
    public void retrieveApiUrl() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET);
        JsonPath jsonPath = request.jsonPath();
        this.apiUrl = this.parseApiUrl(jsonPath);
    }

    @Test(description="Implements Abstract Test 4 (/conf/core/api-definition)", groups={"apidefinition"}, dependsOnGroups={"landingpage"})
    public void openapiDocumentRetrieval() {
        if (this.apiUrl == null || this.apiUrl.isEmpty()) {
            throw new AssertionError((Object)"Path to the API Definition could not be constructed from the landing page");
        }
        Response request = (Response)this.init().baseUri(this.apiUrl).accept("application/vnd.oai.openapi+json;version=3.0").when().request(Method.GET);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.asString();
    }

    @Test(description="Implements Abstract Test 5 (/conf/core/api-definition-success)", groups={"apidefinition"}, dependsOnMethods={"openapiDocumentRetrieval"})
    public void apiDefinitionValidation(ITestContext testContext) throws MalformedURLException {
        OpenApiParser parser = new OpenApiParser();
        OpenApi3 apiModel = null;
        try {
            apiModel = (OpenApi3)parser.parse(new URL(this.apiUrl).toURI(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            EtsAssert.assertTrue(false, "The API definition linked from the Landing Page resulted in " + e.getMessage());
        }
        EtsAssert.assertTrue(apiModel.isValid(), this.createValidationMsg(apiModel));
        testContext.getSuite().setAttribute(SuiteAttribute.API_MODEL.getName(), (Object)apiModel);
    }

    private String parseApiUrl(JsonPath jsonPath) {
        for (Object link : jsonPath.getList("links")) {
            Map linkMap = (Map)link;
            Object rel = linkMap.get("rel");
            Object type = linkMap.get("type");
            if (!"service-doc".equals(rel) && !"service-desc".equals(rel)) continue;
            return (String)linkMap.get("href");
        }
        return null;
    }

    private String createValidationMsg(OpenApi3 model) {
        StringBuilder sb = new StringBuilder();
        sb.append("API definition is not valid. Found following validation items:");
        if (!model.isValid()) {
            for (ValidationResults.ValidationItem item : model.getValidationItems()) {
                sb.append("  @ ").append(item.getPositionInfo()).append("  - ").append(item.getSeverity()).append(": ").append(item.getMsg());
            }
        }
        return sb.toString();
    }
}

