/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.feature;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.geotoolkit.util.Utilities;
import org.opengis.feature.type.Name;

public class DefaultName
implements Name,
Serializable {
    private final String namespace;
    private final String local;
    private final String separator;

    public DefaultName(String local) {
        this(null, local);
    }

    public DefaultName(QName qname) {
        this(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public DefaultName(String namespace, String local) {
        this(namespace, ":", local);
    }

    public DefaultName(String namespace, String separator, String local) {
        this.namespace = namespace;
        this.separator = separator;
        this.local = local;
    }

    @Override
    public boolean isGlobal() {
        return this.getNamespaceURI() == null;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespace;
    }

    @Override
    public String getLocalPart() {
        return this.local;
    }

    @Override
    public String getURI() {
        if (this.namespace == null && this.local == null) {
            return null;
        }
        if (this.namespace == null) {
            return this.local;
        }
        if (this.local == null) {
            return this.namespace;
        }
        return this.namespace + this.separator + this.local;
    }

    @Override
    public int hashCode() {
        return (this.namespace == null ? 0 : this.namespace.hashCode()) + 37 * (this.local == null ? 0 : this.local.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name) {
            Name other = (Name)obj;
            if (!(other.getNamespaceURI() == null || other.getNamespaceURI().isEmpty() || this.getNamespaceURI() == null || this.getNamespaceURI().isEmpty() || Utilities.equals(this.getNamespaceURI(), other.getNamespaceURI()))) {
                return false;
            }
            return Utilities.equals(this.local, other.getLocalPart());
        }
        return false;
    }

    @Override
    public String toString() {
        return DefaultName.toJCRExtendedForm(this);
    }

    public static Name valueOf(String candidate) {
        if (candidate.startsWith("{")) {
            return DefaultName.toSessionNamespaceFromExtended(candidate);
        }
        int index = candidate.lastIndexOf(58);
        if (index <= 0) {
            return new DefaultName(null, candidate);
        }
        String uri = candidate.substring(0, index);
        String name = candidate.substring(index + 1, candidate.length());
        return new DefaultName(uri, name);
    }

    private static Name toSessionNamespaceFromExtended(String candidate) {
        int index = candidate.indexOf(125);
        if (index == -1) {
            throw new IllegalArgumentException("Invalide extended form : " + candidate);
        }
        String uri = candidate.substring(1, index);
        String name = candidate.substring(index + 1, candidate.length());
        return new DefaultName(uri, name);
    }

    public static String toJCRExtendedForm(Name name) {
        String uri = name.getNamespaceURI();
        if (uri == null) {
            return name.getLocalPart();
        }
        return "{" + uri + '}' + name.getLocalPart();
    }

    public static String toExtendedForm(Name name) {
        String uri = name.getNamespaceURI();
        if (uri == null) {
            return name.getLocalPart();
        }
        return uri + ':' + name.getLocalPart();
    }

    public static boolean match(Name name, String candidate) {
        if (candidate.startsWith("{")) {
            return candidate.equals(DefaultName.toJCRExtendedForm(name));
        }
        int index = candidate.lastIndexOf(58);
        if (index <= 0) {
            return candidate.equals(name.getLocalPart());
        }
        String uri = candidate.substring(0, index);
        String local = candidate.substring(index + 1, candidate.length());
        return uri.equals(name.getNamespaceURI()) && local.equals(name.getLocalPart());
    }

    public static boolean match(Name name, Name candidate) {
        if (name.getNamespaceURI() == null || candidate.getNamespaceURI() == null) {
            return name.getLocalPart().equals(candidate.getLocalPart());
        }
        return name.getNamespaceURI().equals(candidate.getNamespaceURI()) && name.getLocalPart().equals(candidate.getLocalPart());
    }
}

