/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

class ArrayEnvelope
extends AbstractEnvelope
implements Serializable {
    private static final long serialVersionUID = 7284917239693486738L;
    final double[] ordinates;
    CoordinateReferenceSystem crs;

    public ArrayEnvelope(int n) {
        this.ordinates = new double[n << 1];
    }

    public ArrayEnvelope(double d, double d2) {
        this.ordinates = new double[]{d, d2};
    }

    public ArrayEnvelope(double d, double d2, double d3, double d4) {
        this.ordinates = new double[]{d, d3, d2, d4};
    }

    public ArrayEnvelope(double[] dArray, double[] dArray2) {
        ArgumentChecks.ensureNonNull("minDP", dArray);
        ArgumentChecks.ensureNonNull("maxDP", dArray2);
        ArrayEnvelope.ensureSameDimension(dArray.length, dArray2.length);
        this.ordinates = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.ordinates, dArray.length, dArray2.length);
    }

    public ArrayEnvelope(Envelope envelope) {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        if (envelope instanceof ArrayEnvelope) {
            ArrayEnvelope arrayEnvelope = (ArrayEnvelope)envelope;
            this.ordinates = (double[])arrayEnvelope.ordinates.clone();
            this.crs = arrayEnvelope.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int n = envelope.getDimension();
            this.ordinates = new double[2 * n];
            for (int i = 0; i < n; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + n] = envelope.getMaximum(i);
            }
        }
    }

    public ArrayEnvelope(GeographicBoundingBox geographicBoundingBox) {
        ArgumentChecks.ensureNonNull("box", geographicBoundingBox);
        this.ordinates = new double[]{geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getNorthBoundLatitude()};
        if (Boolean.FALSE.equals(geographicBoundingBox.getInclusion())) {
            this.swap(0);
            if (!InternalUtilities.isPoleToPole(this.ordinates[1], this.ordinates[3])) {
                this.swap(1);
            }
        }
        this.crs = DefaultGeographicCRS.WGS84;
    }

    public ArrayEnvelope(Rectangle2D rectangle2D) {
        ArgumentChecks.ensureNonNull("rect", rectangle2D);
        this.ordinates = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
    }

    /*
     * Unable to fully structure code
     */
    public ArrayEnvelope(String var1_1) throws NumberFormatException, IllegalArgumentException {
        super();
        ArgumentChecks.ensureNonNull("wkt", var1_1);
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 4;
        var5_5 = 0;
        var6_6 = var1_1.length();
        var7_7 = new double[var4_4];
        var8_8 = new double[var4_4];
        var9_9 = 0;
        block12: for (var10_10 = 0; var10_10 < var6_6; ++var10_10) {
            var11_11 = var1_1.charAt(var10_10);
            if (!Character.isJavaIdentifierStart(var11_11)) ** GOTO lbl17
            while (++var10_10 < var6_6) {
                var11_11 = var1_1.charAt(var10_10);
                if (Character.isJavaIdentifierPart(var11_11)) continue;
lbl17:
                // 2 sources

                if (Character.isWhitespace(var11_11)) continue block12;
                switch (var11_11) {
                    case ',': {
                        var9_9 = 0;
                        continue block12;
                    }
                    case '(': {
                        ++var2_2;
                        var9_9 = 0;
                        continue block12;
                    }
                    case '[': {
                        ++var3_3;
                        var9_9 = 0;
                        continue block12;
                    }
                    case ')': {
                        if (--var2_2 < 0) {
                            ArrayEnvelope.fail(var1_1, '(');
                        }
                        var9_9 = 0;
                        continue block12;
                    }
                    case ']': {
                        if (--var3_3 < 0) {
                            ArrayEnvelope.fail(var1_1, '[');
                        }
                        var9_9 = 0;
                        continue block12;
                    }
                    default: {
                        var12_12 = var10_10;
                        var13_13 = false;
                        block14: while (++var10_10 < var6_6 && !Character.isWhitespace(var11_11 = var1_1.charAt(var10_10))) {
                            switch (var11_11) {
                                case ',': {
                                    var13_13 = true;
                                    break block14;
                                }
                                case ')': {
                                    if (--var2_2 < 0) {
                                        ArrayEnvelope.fail(var1_1, '(');
                                    }
                                    var13_13 = true;
                                    break block14;
                                }
                                case ']': {
                                    if (--var3_3 < 0) {
                                        ArrayEnvelope.fail(var1_1, '[');
                                    }
                                    var13_13 = true;
                                    break block14;
                                }
                                default: {
                                    continue block14;
                                }
                            }
                        }
                        var14_14 = Double.parseDouble(var1_1.substring(var12_12, var10_10));
                        if (var9_9 == var5_5) {
                            if (var9_9 == var4_4) {
                                var7_7 = Arrays.copyOf(var7_7, var4_4 *= 2);
                                var8_8 = Arrays.copyOf(var8_8, var4_4);
                            }
                            var7_7[var9_9] = var8_8[var9_9] = var14_14;
                            var5_5 = ++var9_9;
                        } else {
                            if (var14_14 < var7_7[var9_9]) {
                                var7_7[var9_9] = var14_14;
                            }
                            if (var14_14 > var8_8[var9_9]) {
                                var8_8[var9_9] = var14_14;
                            }
                            ++var9_9;
                        }
                        if (!var13_13) continue block12;
                        var9_9 = 0;
                    }
                }
                continue block12;
            }
            break block12;
        }
        if (var2_2 != 0) {
            ArrayEnvelope.fail(var1_1, ')');
        }
        if (var3_3 != 0) {
            ArrayEnvelope.fail(var1_1, ']');
        }
        this.ordinates = XArrays.resize(var7_7, var5_5 << 1);
        System.arraycopy(var8_8, 0, this.ordinates, var5_5, var5_5);
    }

    private static void fail(String string, char c) {
        throw new IllegalArgumentException(Errors.format(132, string, Character.valueOf(c)));
    }

    static void ensureSameDimension(int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(112, n, n2));
        }
    }

    private void swap(int n) {
        int n2 = n + (this.ordinates.length >>> 1);
        double d = this.ordinates[n];
        this.ordinates[n] = this.ordinates[n2];
        this.ordinates[n2] = d;
    }

    @Override
    public int getDimension() {
        return this.ordinates.length >>> 1;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    @Override
    public DirectPosition getLowerCorner() {
        int n = this.ordinates.length >>> 1;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, 0, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    @Override
    public DirectPosition getUpperCorner() {
        int n = this.ordinates.length >>> 1;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, n, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    @Override
    public double getLower(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.ordinates.length >>> 1, n);
        return this.ordinates[n];
    }

    @Override
    public double getUpper(int n) throws IndexOutOfBoundsException {
        int n2 = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex(n2, n);
        return this.ordinates[n + n2];
    }

    @Override
    public double getMinimum(int n) throws IndexOutOfBoundsException {
        int n2 = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex(n2, n);
        double d = this.ordinates[n];
        if (XMath.isNegative(this.ordinates[n + n2] - d)) {
            CoordinateSystemAxis coordinateSystemAxis = ArrayEnvelope.getAxis(this.crs, n);
            d = coordinateSystemAxis != null ? coordinateSystemAxis.getMinimumValue() : Double.NEGATIVE_INFINITY;
        }
        return d;
    }

    @Override
    public double getMaximum(int n) throws IndexOutOfBoundsException {
        int n2 = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex(n2, n);
        double d = this.ordinates[n + n2];
        if (XMath.isNegative(d - this.ordinates[n])) {
            CoordinateSystemAxis coordinateSystemAxis = ArrayEnvelope.getAxis(this.crs, n);
            d = coordinateSystemAxis != null ? coordinateSystemAxis.getMaximumValue() : Double.POSITIVE_INFINITY;
        }
        return d;
    }

    @Override
    public double getMedian(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.ordinates.length >>> 1, n);
        double d = this.ordinates[n];
        double d2 = this.ordinates[n + (this.ordinates.length >>> 1)];
        double d3 = 0.5 * (d + d2);
        if (XMath.isNegative(d2 - d)) {
            d3 = ArrayEnvelope.fixMedian(ArrayEnvelope.getAxis(this.crs, n), d3);
        }
        return d3;
    }

    @Override
    public double getSpan(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.ordinates.length >>> 1, n);
        double d = this.ordinates[n + (this.ordinates.length >>> 1)] - this.ordinates[n];
        if (XMath.isNegative(d)) {
            d = ArrayEnvelope.fixSpan(ArrayEnvelope.getAxis(this.crs, n), d);
        }
        return d;
    }

    @Override
    public boolean isEmpty() {
        int n = this.ordinates.length >>> 1;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            double d = this.ordinates[i + n] - this.ordinates[i];
            if (d > 0.0 || XMath.isNegative(d) && ArrayEnvelope.isWrapAround(this.crs, i)) continue;
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    @Override
    public boolean isNull() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (Double.isNaN(this.ordinates[i])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ArrayEnvelope arrayEnvelope = (ArrayEnvelope)object;
            return Arrays.equals(this.ordinates, arrayEnvelope.ordinates) && Utilities.equals(this.crs, arrayEnvelope.crs);
        }
        return false;
    }
}

