/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Disposable;

@ThreadSafe
public abstract class UUIDs<T> {
    @GuardedBy(value="this")
    private final Map<T, WeakRef> uuidToObject = new HashMap<T, WeakRef>();
    @GuardedBy(value="this")
    private final Map<WeakRef, T> objectToUUID = new HashMap<WeakRef, T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object lookup(T t) {
        Reference reference;
        UUIDs uUIDs = this;
        synchronized (uUIDs) {
            reference = this.uuidToObject.get(t);
        }
        return reference != null ? reference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getUUID(Object object) {
        StrongRef strongRef = new StrongRef(object);
        UUIDs uUIDs = this;
        synchronized (uUIDs) {
            return this.objectToUUID.get(strongRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object setUUID(Object object, T t) throws IllegalArgumentException {
        StrongRef strongRef = new StrongRef(object);
        UUIDs uUIDs = this;
        synchronized (uUIDs) {
            T t2 = this.objectToUUID.get(strongRef);
            if (t2 != null) {
                if (!t2.equals(t)) {
                    throw new IllegalArgumentException(Errors.format(245, object));
                }
            } else {
                Object t3;
                WeakRef weakRef = new WeakRef(object);
                WeakRef weakRef2 = this.uuidToObject.put(t, weakRef);
                if (weakRef2 != null && (t3 = weakRef2.get()) != null) {
                    this.uuidToObject.put(t, weakRef2);
                    return t3;
                }
                if (this.objectToUUID.put(weakRef, t) != null) {
                    throw new AssertionError(weakRef);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T removeUUID(Object object) {
        T t;
        StrongRef strongRef = new StrongRef(object);
        UUIDs uUIDs = this;
        synchronized (uUIDs) {
            t = this.objectToUUID.remove(strongRef);
            if (t != null && this.uuidToObject.remove(t) == null) {
                throw new AssertionError(t);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getOrCreateUUID(Object object) {
        StrongRef strongRef = new StrongRef(object);
        UUIDs uUIDs = this;
        synchronized (uUIDs) {
            T t = this.objectToUUID.get(strongRef);
            if (t == null) {
                WeakRef weakRef;
                WeakRef weakRef2 = new WeakRef(object);
                while ((weakRef = this.uuidToObject.put(t = this.createUUID(), weakRef2)) != null) {
                    this.uuidToObject.put(t, weakRef);
                }
                if (this.objectToUUID.put(weakRef2, t) != null) {
                    throw new AssertionError(weakRef2);
                }
            }
            return t;
        }
    }

    protected abstract T createUUID();

    private static final class StrongRef {
        private final Object referent;

        private StrongRef(Object object) {
            this.referent = object;
        }

        final boolean same(Reference<?> reference) {
            return reference.get() == this.referent;
        }

        public boolean equals(Object object) {
            if (object instanceof Reference) {
                return this.same((Reference)object);
            }
            return object instanceof StrongRef && ((StrongRef)object).referent == this.referent;
        }

        public int hashCode() {
            return System.identityHashCode(this.referent);
        }
    }

    private final class WeakRef
    extends WeakReference<Object>
    implements Disposable {
        private final int hashCode;

        WeakRef(Object object) {
            super(object, ReferenceQueueConsumer.DEFAULT.queue);
            this.hashCode = System.identityHashCode(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            WeakRef weakRef;
            Object v;
            UUIDs uUIDs = UUIDs.this;
            synchronized (uUIDs) {
                v = UUIDs.this.objectToUUID.remove(this);
                weakRef = (WeakRef)UUIDs.this.uuidToObject.remove(v);
            }
            assert (weakRef == this) : v;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof StrongRef && ((StrongRef)object).same(this);
        }
    }

    public static final class AsString
    extends UUIDs<String> {
        private final Random random = new Random();

        @Override
        protected String createUUID() {
            char[] cArray = new char[6];
            for (int i = 0; i < cArray.length; ++i) {
                int n = this.random.nextInt(i == 0 ? 26 : 36);
                cArray[i] = (char)(n + (n < 26 ? 65 : 22));
            }
            return new String(cArray);
        }
    }

    public static final class Standard
    extends UUIDs<UUID> {
        @Override
        protected UUID createUUID() {
            return UUID.randomUUID();
        }
    }
}

