/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import org.geotoolkit.math.ExtrapolationException;
import org.geotoolkit.math.Search1D;

public class Spline1D
extends Search1D {
    public double dx;
    private final double yp1;
    private final double ypn;
    private double[] y2;
    private double[] sentry;

    public Spline1D() {
        this.ypn = Double.NaN;
        this.yp1 = Double.NaN;
    }

    public Spline1D(double yp1, double ypn) {
        this.yp1 = yp1;
        this.ypn = ypn;
    }

    @Override
    public void clear() {
        super.clear();
        this.y2 = null;
        this.sentry = this.y;
    }

    @Override
    public void recompute() {
        this.y2 = null;
        this.sentry = this.y;
    }

    @Override
    protected double interpolate(double xi, boolean reUseIndex) throws ExtrapolationException {
        if (this.ignoreYNaN && !reUseIndex) {
            this.validateIndex(this.sentry);
        }
        if (this.khi != this.klo) {
            if (this.y2 == null) {
                this.constructY2();
            }
            double a = this.x[this.khi];
            double b = this.x[this.klo];
            this.dx = a - b;
            a = (a - xi) / this.dx;
            b = (xi - b) / this.dx;
            return (float)(a * this.y[this.klo] + b * this.y[this.khi] + ((a * a * a - a) * this.y2[this.klo] + (b * b * b - b) * this.y2[this.khi]) * (this.dx * this.dx) / 6.0);
        }
        return this.y[this.khi];
    }

    private final void constructY2() {
        this.y2 = new double[this.y.length];
        this.sentry = this.y2;
        double[] u = new double[this.y.length];
        int previous = 0;
        while (true) {
            if (previous >= this.y.length) {
                this.throwArrayIndexOutOfBoundsException(2);
            }
            if (!Double.isNaN(this.x[previous]) && !Double.isNaN(this.y[previous])) break;
            this.y2[previous++] = Double.NaN;
        }
        int i = previous;
        while (true) {
            if (++i >= this.y.length) {
                this.throwArrayIndexOutOfBoundsException(2);
            }
            if (!Double.isNaN(this.x[i]) && !Double.isNaN(this.y[i])) break;
            this.y2[i] = Double.NaN;
        }
        if (!Double.isNaN(this.yp1)) {
            double dx = this.x[i] - this.x[previous];
            this.y2[previous] = -0.5;
            u[previous] = (float)(3.0 / dx * ((this.y[i] - this.y[previous]) / dx - this.yp1));
        } else {
            u[previous] = 0.0;
            this.y2[previous] = 0.0;
        }
        int next = i;
        while (++next < this.y.length) {
            if (!Double.isNaN(this.x[next]) && !Double.isNaN(this.y[next])) {
                double xp = this.x[previous];
                double xi = this.x[i];
                double xn = this.x[next];
                double sig = (xi - xp) / (xn - xp);
                double p = sig * this.y2[previous] + 2.0;
                this.y2[i] = (float)((sig - 1.0) / p);
                u[i] = (float)((this.y[next] - this.y[i]) / (xn - xi) - (this.y[i] - this.y[previous]) / (xi - xp));
                u[i] = (float)((6.0 * u[i] / (xn - xp) - sig * u[previous]) / p);
                previous = i;
                i = next;
                continue;
            }
            this.y2[next] = Double.NaN;
        }
        if (!Double.isNaN(this.ypn)) {
            double dx = this.x[i] - this.x[previous];
            double un = 3.0 / dx * (this.ypn - (this.y[i] - this.y[previous]) / dx);
            this.y2[i] = (float)((un - 0.5 * u[previous]) / (0.5 * this.y2[previous] + 1.0));
        } else {
            this.y2[i] = 0.0;
        }
        do {
            if (Double.isNaN(this.y2[previous])) continue;
            this.y2[previous] = this.y2[previous] * this.y2[i] + u[previous];
            i = previous;
        } while (--previous >= 0);
    }

    @Override
    public double[] interpolateNaN(double dxStart, double dxStop) {
        return this.interpolateNaN(dxStart, dxStop, this.y);
    }
}

