/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@Immutable
public class DefaultCompoundCS
extends AbstractCS {
    private static final long serialVersionUID = -5726410275278843373L;
    private final CoordinateSystem[] components;
    private transient List<CoordinateSystem> asList;

    public DefaultCompoundCS(CoordinateSystem ... coordinateSystemArray) {
        coordinateSystemArray = DefaultCompoundCS.clone(coordinateSystemArray);
        super(DefaultCompoundCS.getName(coordinateSystemArray), DefaultCompoundCS.getAxis(coordinateSystemArray));
        this.components = coordinateSystemArray;
    }

    private static CoordinateSystem[] clone(CoordinateSystem[] coordinateSystemArray) {
        ArgumentChecks.ensureNonNull("components", coordinateSystemArray);
        coordinateSystemArray = (CoordinateSystem[])coordinateSystemArray.clone();
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            ArgumentChecks.ensureNonNull("components", i, coordinateSystemArray);
        }
        return coordinateSystemArray;
    }

    private static CoordinateSystemAxis[] getAxis(CoordinateSystem[] coordinateSystemArray) {
        int n = 0;
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            n += coordinateSystemArray[i].getDimension();
        }
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        n = 0;
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            CoordinateSystem coordinateSystem = coordinateSystemArray[i];
            int n2 = coordinateSystem.getDimension();
            for (int j = 0; j < n2; ++j) {
                coordinateSystemAxisArray[n++] = coordinateSystem.getAxis(j);
            }
        }
        assert (n == coordinateSystemAxisArray.length);
        return coordinateSystemAxisArray;
    }

    private static String getName(CoordinateSystem[] coordinateSystemArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" / ");
            }
            stringBuilder.append(coordinateSystemArray[i].getName().getCode());
        }
        return stringBuilder.toString();
    }

    public synchronized List<CoordinateSystem> getComponents() {
        if (this.asList == null) {
            this.asList = Collections.unmodifiableList(Arrays.asList(this.components));
        }
        return this.asList;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultCompoundCS && super.equals(object, comparisonMode)) {
            DefaultCompoundCS defaultCompoundCS = (DefaultCompoundCS)object;
            return Utilities.deepEquals(this.components, defaultCompoundCS.components, comparisonMode);
        }
        return false;
    }
}

