/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.ParameterizedAffine;
import org.geotoolkit.internal.referencing.Semaphores;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.referencing.operation.DefaultConicProjection;
import org.geotoolkit.referencing.operation.DefaultConversion;
import org.geotoolkit.referencing.operation.DefaultCylindricalProjection;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultPlanarProjection;
import org.geotoolkit.referencing.operation.DefaultProjection;
import org.geotoolkit.referencing.operation.DefaultTransformation;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;

@Immutable
public class DefaultSingleOperation
extends AbstractCoordinateOperation
implements SingleOperation {
    private static final long serialVersionUID = -2635450075620911309L;
    protected final OperationMethod method;
    ParameterValueGroup parameters;

    DefaultSingleOperation(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        this.method = conversion.getMethod();
    }

    public DefaultSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        DefaultOperationMethod.checkDimensions(operationMethod, mathTransform);
        this.method = operationMethod;
        Object obj = map.get("parameters");
        if (obj instanceof ParameterValueGroup) {
            this.parameters = (ParameterValueGroup)obj;
        }
    }

    public static CoordinateOperation create(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod, Class<? extends CoordinateOperation> clazz) {
        if (operationMethod != null) {
            Class<? extends SingleOperation> clazz2;
            if (operationMethod instanceof MathTransformProvider && (clazz2 = ((MathTransformProvider)operationMethod).getOperationType()) != null) {
                if (clazz == null) {
                    clazz = clazz2;
                } else if (clazz.isAssignableFrom(clazz2)) {
                    clazz = clazz2.asSubclass(clazz);
                }
            }
            if (clazz != null) {
                if (Transformation.class.isAssignableFrom(clazz)) {
                    return new DefaultTransformation(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (ConicProjection.class.isAssignableFrom(clazz)) {
                    return new DefaultConicProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (CylindricalProjection.class.isAssignableFrom(clazz)) {
                    return new DefaultCylindricalProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (PlanarProjection.class.isAssignableFrom(clazz)) {
                    return new DefaultPlanarProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (Projection.class.isAssignableFrom(clazz)) {
                    return new DefaultProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (Conversion.class.isAssignableFrom(clazz)) {
                    return new DefaultConversion(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
            }
            return new DefaultSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
        }
        return new AbstractCoordinateOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }

    @Override
    public OperationMethod getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        if (this.parameters != null) {
            return this.parameters.clone();
        }
        MathTransform mathTransform = this.transform;
        while (mathTransform != null) {
            if (mathTransform instanceof Parameterized) {
                ParameterValueGroup parameterValueGroup;
                if (mathTransform instanceof ParameterizedAffine) {
                    parameterValueGroup = ((ParameterizedAffine)mathTransform).parameters.getParameterValues();
                } else {
                    if (Semaphores.queryAndSet(2)) {
                        throw new AssertionError();
                    }
                    try {
                        parameterValueGroup = ((Parameterized)((Object)mathTransform)).getParameterValues();
                    }
                    finally {
                        Semaphores.clear(2);
                    }
                }
                if (parameterValueGroup != null) {
                    return parameterValueGroup;
                }
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        throw new UnsupportedImplementationException(Classes.getClass(mathTransform));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultSingleOperation defaultSingleOperation = (DefaultSingleOperation)object;
                    return Utilities.equals(this.method, defaultSingleOperation.method);
                }
                case BY_CONTRACT: {
                    SingleOperation singleOperation = (SingleOperation)object;
                    return Utilities.deepEquals(this.getMethod(), singleOperation.getMethod(), comparisonMode);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        String string = super.formatWKT(formatter);
        DefaultSingleOperation.append(formatter, this.method, "METHOD");
        return string;
    }
}

