/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import javax.vecmath.Matrix3d;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.operation.matrix.AffineMatrix3;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.operation.Matrix;

public class Matrix3
extends Matrix3d
implements XMatrix {
    private static final long serialVersionUID = 8902061778871586611L;
    public static final int SIZE = 3;

    public Matrix3() {
        this.setIdentity();
    }

    public Matrix3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public Matrix3(double[] dArray) {
        super(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8]);
        if (dArray.length != 9) {
            throw new IllegalArgumentException(Errors.format(109));
        }
    }

    public Matrix3(AffineTransform affineTransform) {
        this.setMatrix(affineTransform);
    }

    public Matrix3(Matrix matrix) throws IllegalArgumentException {
        if (matrix.getNumRow() != 3 || matrix.getNumCol() != 3) {
            throw new IllegalArgumentException(Errors.format(85));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    @Override
    public final boolean isIdentity() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.getElement(i, j) == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isIdentity(double d) {
        return GeneralMatrix.isIdentity(this, d);
    }

    @Override
    public final boolean isAffine() {
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.m00) || Double.isNaN(this.m01) || Double.isNaN(this.m02) || Double.isNaN(this.m10) || Double.isNaN(this.m11) || Double.isNaN(this.m12) || Double.isNaN(this.m20) || Double.isNaN(this.m21) || Double.isNaN(this.m22);
    }

    @Override
    public final void multiply(Matrix matrix) {
        Matrix3d matrix3d = matrix instanceof Matrix3d ? (Matrix3d)((Object)matrix) : new Matrix3(matrix);
        this.mul(matrix3d);
    }

    @Override
    public final void normalizeColumns() {
        double[] dArray = new double[]{this.m00, this.m10, this.m20};
        double d = XMath.magnitude(dArray);
        this.m00 /= d;
        this.m10 /= d;
        this.m20 /= d;
        dArray[0] = this.m01;
        dArray[1] = this.m11;
        dArray[2] = this.m21;
        d = XMath.magnitude(dArray);
        this.m01 /= d;
        this.m11 /= d;
        this.m21 /= d;
        dArray[0] = this.m02;
        dArray[1] = this.m12;
        dArray[2] = this.m22;
        d = XMath.magnitude(dArray);
        this.m02 /= d;
        this.m12 /= d;
        this.m22 /= d;
    }

    public void setMatrix(AffineTransform affineTransform) {
        this.m00 = affineTransform.getScaleX();
        this.m01 = affineTransform.getShearX();
        this.m02 = affineTransform.getTranslateX();
        this.m10 = affineTransform.getShearY();
        this.m11 = affineTransform.getScaleY();
        this.m12 = affineTransform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public AffineTransform toAffineTransform() throws IllegalStateException {
        if (this.isAffine()) {
            return new AffineMatrix3(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
        }
        throw new IllegalStateException(Errors.format(140));
    }

    public boolean equalsAffine(AffineTransform affineTransform) {
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && Utilities.equals(this.m00, affineTransform.getScaleX()) && Utilities.equals(this.m11, affineTransform.getScaleY()) && Utilities.equals(this.m01, affineTransform.getShearX()) && Utilities.equals(this.m10, affineTransform.getShearY()) && Utilities.equals(this.m02, affineTransform.getTranslateX()) && Utilities.equals(this.m12, affineTransform.getTranslateY());
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return Matrices.equals(this, matrix, d, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, comparisonMode);
    }

    @Override
    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix3 clone() {
        return (Matrix3)super.clone();
    }
}

