/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import javax.measure.unit.Unit;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.operation.provider.MapProjectionDescriptor;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;

final class MapProjectionParameters
extends ParameterGroup {
    private static final long serialVersionUID = -6801091012335717139L;
    private transient ParameterValue<Double> earthRadius;
    private transient ParameterValue<Double> inverseFlattening;
    private transient ParameterValue<double[]> standardParallel;

    MapProjectionParameters(MapProjectionDescriptor mapProjectionDescriptor) {
        super(mapProjectionDescriptor);
    }

    final double get(ParameterDescriptor<Double> parameterDescriptor) {
        return Parameters.doubleValue(parameterDescriptor, this);
    }

    final void set(ParameterDescriptor<Double> parameterDescriptor, double d, Unit<?> unit) {
        Parameters.getOrCreate(parameterDescriptor, this).setValue(d, unit);
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        string = string.trim();
        int n = ((MapProjectionDescriptor)this.getDescriptor()).supplement;
        if ((n & 1) != 0) {
            if (string.equalsIgnoreCase("earth_radius")) {
                EarthRadius earthRadius = this.earthRadius;
                if (earthRadius == null) {
                    earthRadius = this.earthRadius = new EarthRadius();
                }
                return earthRadius;
            }
            if (string.equalsIgnoreCase("inverse_flattening")) {
                InverseFlattening inverseFlattening = this.inverseFlattening;
                if (inverseFlattening == null) {
                    inverseFlattening = this.inverseFlattening = new InverseFlattening();
                }
                return inverseFlattening;
            }
        }
        if ((n & 2) != 0 && string.equalsIgnoreCase("standard_parallel")) {
            StandardParallel standardParallel = this.standardParallel;
            if (standardParallel == null) {
                standardParallel = this.standardParallel = new StandardParallel();
            }
            return standardParallel;
        }
        return super.parameter(string);
    }

    private final class StandardParallel
    extends Parameter<double[]> {
        private static final long serialVersionUID = -1379566730374843040L;

        StandardParallel() {
            super(UniversalParameters.STANDARD_PARALLEL);
        }

        @Override
        public double[] getValue() {
            double d = MapProjectionParameters.this.get(UniversalParameters.STANDARD_PARALLEL_1);
            double d2 = MapProjectionParameters.this.get(UniversalParameters.STANDARD_PARALLEL_2);
            if (Double.isNaN(d2)) {
                double[] dArray;
                if (Double.isNaN(d)) {
                    dArray = XArrays.EMPTY_DOUBLE;
                } else {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = d;
                }
                return dArray;
            }
            return new double[]{d, d2};
        }

        @Override
        protected void setSafeValue(double[] dArray, Unit<?> unit) {
            double d = Double.NaN;
            double d2 = Double.NaN;
            if (dArray != null) {
                switch (dArray.length) {
                    default: {
                        throw new IllegalArgumentException(Errors.format(72, "standard_parallel"));
                    }
                    case 2: {
                        d2 = dArray[1];
                    }
                    case 1: {
                        d = dArray[0];
                    }
                    case 0: 
                }
            }
            MapProjectionParameters.this.set(UniversalParameters.STANDARD_PARALLEL_1, d, unit);
            MapProjectionParameters.this.set(UniversalParameters.STANDARD_PARALLEL_2, d2, unit);
        }
    }

    private final class InverseFlattening
    extends FloatParameter
    implements ChangeListener {
        private static final long serialVersionUID = 4490056024453509851L;

        InverseFlattening() {
            super(UniversalParameters.INVERSE_FLATTENING);
        }

        private AbstractParameterValue<?> semiMajor() {
            return (AbstractParameterValue)MapProjectionParameters.this.parameter("semi_major");
        }

        @Override
        public double doubleValue() {
            double d;
            double d2 = MapProjectionParameters.this.get(UniversalParameters.SEMI_MAJOR);
            double d3 = d2 / (d2 - (d = MapProjectionParameters.this.get(UniversalParameters.SEMI_MINOR)));
            if (Double.isNaN(d3)) {
                d3 = super.doubleValue();
            }
            return d3;
        }

        @Override
        public void setValue(double d, Unit<?> unit) {
            boolean bl = Double.isNaN(super.doubleValue());
            super.setValue(d, unit);
            if (Double.isNaN(d)) {
                if (!bl) {
                    this.semiMajor().removeChangeListener(this);
                }
            } else {
                if (bl) {
                    this.semiMajor().addChangeListener(this);
                }
                this.update(d);
            }
        }

        private void update(double d) {
            ParameterValue<?> parameterValue;
            try {
                parameterValue = Parameters.getOrCreate(UniversalParameters.SEMI_MAJOR, MapProjectionParameters.this);
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
            MapProjectionParameters.this.set(UniversalParameters.SEMI_MINOR, parameterValue.doubleValue() * (1.0 - 1.0 / d), parameterValue.getUnit());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.update(super.doubleValue());
        }
    }

    private final class EarthRadius
    extends FloatParameter {
        private static final long serialVersionUID = 5848432458976184182L;

        EarthRadius() {
            super(UniversalParameters.EARTH_RADIUS);
        }

        @Override
        public double doubleValue() {
            return CRSUtilities.getAuthalicRadius(MapProjectionParameters.this.get(UniversalParameters.SEMI_MAJOR), MapProjectionParameters.this.get(UniversalParameters.SEMI_MINOR));
        }

        @Override
        public void setValue(double d, Unit<?> unit) {
            super.setValue(d, unit);
            MapProjectionParameters.this.set(UniversalParameters.SEMI_MAJOR, d, unit);
            MapProjectionParameters.this.set(UniversalParameters.SEMI_MINOR, d, unit);
        }
    }
}

