/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.Date;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.measure.Units;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.Range;

@Immutable
public class DateRange
extends Range<Date> {
    private static final long serialVersionUID = -6400011350250757942L;

    public DateRange(Date date, Date date2) {
        super(Date.class, DateRange.clone(date), DateRange.clone(date2));
    }

    public DateRange(Date date, boolean bl, Date date2, boolean bl2) {
        super(Date.class, DateRange.clone(date), bl, DateRange.clone(date2), bl2);
    }

    public DateRange(MeasurementRange<?> measurementRange, Date date) throws ConversionException {
        this(measurementRange, DateRange.getConverter(measurementRange.getUnits()), date.getTime());
    }

    private DateRange(MeasurementRange<?> measurementRange, UnitConverter unitConverter, long l) throws ConversionException {
        super(Date.class, new Date(l + Math.round(unitConverter.convert(measurementRange.getMinimum()))), measurementRange.isMinIncluded(), new Date(l + Math.round(unitConverter.convert(measurementRange.getMaximum()))), measurementRange.isMaxIncluded());
    }

    final DateRange create(Date date, boolean bl, Date date2, boolean bl2) {
        return new DateRange(date, bl, date2, bl2);
    }

    final DateRange[] newArray(int n) {
        return new DateRange[n];
    }

    @Override
    final void checkElementClass() throws IllegalArgumentException {
        if (!Date.class.isAssignableFrom(this.elementClass)) {
            throw new IllegalArgumentException(Errors.format(76, this.elementClass, Date.class));
        }
    }

    private static DateRange cast(Range<?> range) {
        if (range == null || range instanceof DateRange) {
            return (DateRange)range;
        }
        return new DateRange((Date)range.getMinValue(), range.isMinIncluded(), (Date)range.getMaxValue(), range.isMaxIncluded());
    }

    private static Date clone(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    private static UnitConverter getConverter(Unit<?> unit) throws ConversionException {
        if (unit == null) {
            throw new ConversionException(Errors.format(171));
        }
        return unit.getConverterToAny(Units.MILLISECOND);
    }

    @Override
    public Date getMinValue() {
        return DateRange.clone((Date)super.getMinValue());
    }

    @Override
    public Date getMaxValue() {
        return DateRange.clone((Date)super.getMaxValue());
    }

    public DateRange union(Range<?> range) throws IllegalArgumentException {
        return DateRange.cast(super.union(range));
    }

    public DateRange intersect(Range<?> range) throws IllegalArgumentException {
        return DateRange.cast(super.intersect(range));
    }

    public DateRange[] subtract(Range<?> range) throws IllegalArgumentException {
        return (DateRange[])super.subtract(range);
    }
}

