/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.collections;

import com.reprezen.kaizen.oasparser.model3.Parameter;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opengis.cite.ogcapiedr10.CommonDataFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.collections.FeaturesAssertions;
import org.opengis.cite.ogcapiedr10.openapi3.TestPoint;
import org.opengis.cite.ogcapiedr10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class AbstractFeatures
extends CommonDataFixture {
    String apiDef = null;
    protected final Map<CollectionResponseKey, ResponseData> collectionIdAndResponse = new HashMap<CollectionResponseKey, ResponseData>();
    protected URI iut;

    @DataProvider(name="collectionPaths")
    public Iterator<Object[]> collectionPaths(ITestContext testContext) {
        String[] resources;
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        for (String res : resources = new String[]{"locations", "position", "cube", "corridor", "area", "trajectory"}) {
            testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/" + res, null));
        }
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (TestPoint testPointForCollections : testPointsForCollections) {
            collectionsData.add(new Object[]{testPointForCollections});
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="locationsCollectionPaths")
    public Iterator<Object[]> locationsCollectionPaths(ITestContext testContext) {
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/locations", null));
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        if (this.apiDef.contains("/locations")) {
            for (TestPoint testPointForCollections : testPointsForCollections) {
                collectionsData.add(new Object[]{testPointForCollections});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="positionCollectionPaths")
    public Iterator<Object[]> positionCollectionPaths(ITestContext testContext) {
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/position", null));
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        if (this.apiDef.contains("/position")) {
            for (TestPoint testPointForCollections : testPointsForCollections) {
                collectionsData.add(new Object[]{testPointForCollections});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="areaCollectionPaths")
    public Iterator<Object[]> areaCollectionPaths(ITestContext testContext) {
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/area", null));
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        if (this.apiDef.contains("/area")) {
            for (TestPoint testPointForCollections : testPointsForCollections) {
                collectionsData.add(new Object[]{testPointForCollections});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="trajectoryCollectionPaths")
    public Iterator<Object[]> trajectoryCollectionPaths(ITestContext testContext) {
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/trajectory", null));
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        if (this.apiDef.contains("/trajectory")) {
            for (TestPoint testPointForCollections : testPointsForCollections) {
                collectionsData.add(new Object[]{testPointForCollections});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="cubeCollectionPaths")
    public Iterator<Object[]> cubeCollectionPaths(ITestContext testContext) {
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/cube", null));
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        if (this.apiDef.contains("/cube")) {
            for (TestPoint testPointForCollections : testPointsForCollections) {
                collectionsData.add(new Object[]{testPointForCollections});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="corridorCollectionPaths")
    public Iterator<Object[]> corridorCollectionPaths(ITestContext testContext) {
        ArrayList<TestPoint> testPointsForCollections = new ArrayList<TestPoint>();
        testPointsForCollections.add(new TestPoint(this.rootUri.toString(), "/corridor", null));
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        if (this.apiDef.contains("/corridor")) {
            for (TestPoint testPointForCollections : testPointsForCollections) {
                collectionsData.add(new Object[]{testPointForCollections});
            }
        }
        return collectionsData.iterator();
    }

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        Response response = (Response)this.init().baseUri(this.modelUri.toString()).accept("application/vnd.oai.openapi+json;version=3.0").when().request(Method.GET);
        this.apiDef = response.asString();
    }

    public void validateTypeProperty(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        String type = (String)jsonPath.get("type");
        Assert.assertNotNull(type, "type property is missing");
        Assert.assertEquals(type, "FeatureCollection", "Expected type property value of FeatureCollection but was " + type);
    }

    void validateFeaturesProperty(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        List type = (List)jsonPath.get("features");
        Assert.assertNotNull(type, "features property is missing");
    }

    void validateLinks(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        List<Map<String, Object>> links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, "Feature Collection Metadata document must include a link for itself");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Feature Collection Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        HashSet<String> rels = new HashSet<String>();
        rels.add("self");
        rels.add("alternate");
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(links, rels);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }

    public void validateTimeStamp(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        FeaturesAssertions.assertTimeStamp(collection.id, jsonPath, response.timeStampBeforeResponse, response.timeStampAfterResponse, true);
    }

    void validateNumberReturned(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        FeaturesAssertions.assertNumberReturned(collection.id, jsonPath, true);
    }

    protected String findFeaturesUrlForGeoJson(Map<String, Object> collection) {
        List links = (List)collection.get("links");
        for (Object linkObject : links) {
            Map link = (Map)linkObject;
            Object rel = link.get("rel");
            Object type = link.get("type");
            if (!"items".equals(rel) || !"application/geo+json".equals(type)) continue;
            return (String)link.get("href");
        }
        return null;
    }

    protected boolean isRequired(Parameter param) {
        return param.getRequired() != null && param.getRequired() != false;
    }

    protected Boolean isExplode(Parameter param) {
        return param.getExplode() != null && param.getExplode() != false;
    }

    protected class CollectionResponseKey {
        private final String id;

        protected CollectionResponseKey(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionResponseKey that = (CollectionResponseKey)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    protected class ResponseData {
        private final Response response;
        protected final ZonedDateTime timeStampBeforeResponse;
        protected final ZonedDateTime timeStampAfterResponse;

        public ResponseData(Response response, ZonedDateTime timeStampBeforeResponse, ZonedDateTime timeStampAfterResponse) {
            this.response = response;
            this.timeStampBeforeResponse = timeStampBeforeResponse;
            this.timeStampAfterResponse = timeStampAfterResponse;
        }

        public JsonPath jsonPath() {
            return this.response.jsonPath();
        }
    }
}

