/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.encodings.json;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.response.Response;
import java.io.InputStream;
import java.net.URI;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JSONEncoding
extends CommonFixture {
    protected URI iut;

    @Test(description="Implements Abstract Test 18 (/conf/json/definition), Abstract Test 19 (/conf/json/content)")
    public void validateResponseForJSON() {
        Response response = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET);
        Assert.assertTrue(response.getStatusCode() == 200, "Fails Abstract Test 18, JSON response not supported for landing page");
        Assert.assertTrue(this.isJSONValidPerSchema(response.asString(), "/"), "Fails Abstract Test 19, landing page response not valid JSON");
        response = (Response)this.init().baseUri(this.apiDefUri.toString()).accept("application/vnd.oai.openapi+json;version=3.0").when().request(Method.GET);
        Assert.assertTrue(response.getStatusCode() == 200, "Fails Abstract Test 18, JSON response not supported for api description \nCODE" + response.getStatusCode() + "\n" + this.apiDefUri.toString());
        response = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/conformance", new Object[0]);
        Assert.assertTrue(response.getStatusCode() == 200, "Fails Abstract Test 18, JSON response not supported for conformance declaration");
        Assert.assertTrue(this.isJSONValidPerSchema(response.asString(), "/conformance"), "Fails Abstract Test 19, conformance declaration response not valid JSON");
        response = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        Assert.assertTrue(response.getStatusCode() == 200, "Fails Abstract Test 18, JSON response not supported for collections metadata");
    }

    private boolean isJSONValidPerSchema(String doc, String path) {
        boolean valid = false;
        if (path.equals("/")) {
            try (InputStream inputStream = this.getClass().getResourceAsStream("/org/opengis/cite/ogcapiedr10/jsonschema/landingPage.json");){
                JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
                Schema schema = SchemaLoader.load(rawSchema);
                schema.validate(new JSONObject(doc));
                valid = true;
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        } else if (path.equals("/conformance")) {
            try (InputStream inputStream = this.getClass().getResourceAsStream("/org/opengis/cite/ogcapiedr10/jsonschema/confClasses.json");){
                JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
                Schema schema = SchemaLoader.load(rawSchema);
                schema.validate(new JSONObject(doc));
                valid = true;
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        } else {
            valid = true;
        }
        return valid;
    }
}

