/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.conformance;

import com.reprezen.kaizen.oasparser.OpenApiParser;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.util.Link;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ApiDefinition
extends CommonFixture {
    private String response;
    private Link apiUrl = null;

    @BeforeClass(dependsOnMethods={"initCommonFixture"})
    public void retrieveApiUrl() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET);
        JsonPath jsonPath = request.jsonPath();
        this.apiUrl = this.parseApiUrl(jsonPath);
    }

    @Test(description="Implements Abstract Test 4 (/conf/core/api-definition)", groups={"apidefinition"}, dependsOnGroups={"landingpage"})
    public void openapiDocumentRetrieval() {
        if (this.apiUrl == null || this.apiUrl.getHref().isEmpty()) {
            throw new AssertionError((Object)"Path to the API Definition could not be constructed from the landing page");
        }
        Response request = (Response)this.init().baseUri(this.apiUrl.getHref()).accept(this.apiUrl.getType()).when().request(Method.GET);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.asString();
    }

    @Test(description="Implements Abstract Test 5 (/conf/core/api-definition-success)", groups={"apidefinition"}, dependsOnMethods={"openapiDocumentRetrieval"})
    public void apiDefinitionValidation(ITestContext testContext) throws MalformedURLException {
        OpenApiParser parser = new OpenApiParser();
        OpenApi3 apiModel = null;
        Response response = (Response)this.init().baseUri(this.apiUrl.getHref()).accept(this.apiUrl.getType()).when().request(Method.GET);
        try {
            URL resolutionBase = new URL(this.apiUrl.getHref());
            apiModel = (OpenApi3)parser.parse(response.asString(), resolutionBase);
        }
        catch (Exception e) {
            e.printStackTrace();
            EtsAssert.assertTrue(false, "The API definition linked from the Landing Page resulted in " + this.apiUrl + " \n" + e.getMessage());
        }
        if (apiModel.isValid()) {
            testContext.getSuite().setAttribute(SuiteAttribute.API_MODEL.getName(), (Object)apiModel);
        }
        if (apiModel.isValid() && !this.apiUrl.getType().equals("application/vnd.oai.openapi+json;version=3.0")) {
            throw new SkipException("The API Definition was found to be valid. However, the Media Type identified by the Link to the API Definition document was not application/vnd.oai.openapi+json;version=3.0");
        }
        EtsAssert.assertTrue(apiModel.isValid(), this.createValidationMsg(apiModel));
    }

    private Link parseApiUrl(JsonPath jsonPath) {
        for (Object link : jsonPath.getList("links")) {
            Map linkMap = (Map)link;
            Object rel = linkMap.get("rel");
            Object type = linkMap.get("type");
            if ("service-desc".equals(rel)) {
                return new Link((String)linkMap.get("href"), (String)rel, (String)type);
            }
            if (!"service-doc".equals(rel)) continue;
            return new Link((String)linkMap.get("href"), (String)rel, (String)type);
        }
        return null;
    }

    private String createValidationMsg(OpenApi3 model) {
        StringBuilder sb = new StringBuilder();
        sb.append("API definition is not valid. Found following validation items:");
        if (!model.isValid()) {
            for (ValidationResults.ValidationItem item : model.getValidationItems()) {
                sb.append("  @ ").append(item.getPositionInfo()).append("  - ").append(item.getSeverity()).append(": ").append(item.getMsg());
            }
        }
        return sb.toString();
    }
}

