/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;

class KeyConsumer {
    private final Set<String> consumedKeys;
    private final JsonObject schemaJson;

    KeyConsumer(JsonObject schemaJson) {
        this.schemaJson = schemaJson;
        this.consumedKeys = new HashSet<String>(schemaJson.keySet().size());
    }

    void keyConsumed(String key) {
        if (this.schemaJson.keySet().contains(key)) {
            this.consumedKeys.add(key);
        }
    }

    JsonValue require(String key) {
        this.keyConsumed(key);
        return this.schemaJson.require(key);
    }

    Optional<JsonValue> maybe(String key) {
        this.keyConsumed(key);
        return this.schemaJson.maybe(key);
    }

    public Set<String> collect() {
        return this.consumedKeys;
    }
}

