/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.corecollections;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapiedr10.CommonDataFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapiedr10.openapi3.TestPoint;
import org.opengis.cite.ogcapiedr10.openapi3.UriBuilder;
import org.opengis.cite.ogcapiedr10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class Collections
extends CommonDataFixture {
    private final Map<TestPoint, Response> testPointAndResponses = new HashMap<TestPoint, Response>();
    private Object[][] testPointsData;

    @DataProvider(name="collectionsUris")
    public Object[][] collectionsUris(ITestContext testContext) {
        if (this.testPointsData == null) {
            URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
            List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForCollectionsMetadata(this.getModel(), iut);
            this.testPointsData = new Object[testPoints.size()][];
            int i = 0;
            for (TestPoint testPoint : testPoints) {
                this.testPointsData[i++] = new Object[]{testPoint};
                System.out.println("CHKDA1 " + testPoint.getServerUrl() + " | " + testPoint.getPath());
            }
        }
        return this.testPointsData;
    }

    @Test(description="Implements Abstract Test 82, meets Requirement /req/collections/rc-md-op", dataProvider="collectionsUris", dependsOnGroups={"conformance"})
    public void validateCollectionsMetadataOperation(TestPoint testPoint) {
        System.out.println("CHKDA2 " + testPoint.getServerUrl() + " | " + testPoint.getPath());
        String testPointUri = new UriBuilder(testPoint).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.testPointAndResponses.put(testPoint, response);
    }

    @Test(description="Implements Abstract Test 15, meets Requirement /req/edr/rc-md-query-links", dataProvider="collectionsUris", dependsOnMethods={"validateCollectionsMetadataOperation"})
    public void validateCollectionMetadata_Links(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List collections = jsonPath.getList("collections");
        Iterator iterator = collections.iterator();
        while (iterator.hasNext()) {
            Map collection;
            Map map = collection = (Map)iterator.next();
            Object links = map.get("links");
            List collectionLinks = (List)links;
            Boolean relationIsDataOrCollection = false;
            Boolean isValidCollection = false;
            for (Map link : collectionLinks) {
                Object rel = link.get("rel");
                if (!rel.equals("data") && !rel.equals("collection")) continue;
                relationIsDataOrCollection = true;
                if (!JsonUtils.linkIncludesRelAndType(link)) continue;
                isValidCollection = true;
                break;
            }
            EtsAssert.assertTrue(relationIsDataOrCollection, "Collection must include links for data or collection encodings. Missing links for collection " + map.get("id"));
            EtsAssert.assertTrue(isValidCollection, "Links for data or collection encodings must include a rel and type parameter. Missing for collection " + map.get("id"));
        }
    }

    @Test(description="Implements Abstract Test 16, meets Requirement /req/core/rc-collection-info-links", dataProvider="collectionsUris", dependsOnMethods={"validateCollectionsMetadataOperation"})
    public void validateCollectionsMetadata_Links(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, (String)"Collections Metadata document must include a link for itself");
        EtsAssert.assertTrue(JsonUtils.linkIncludesRelAndType(linkToSelf), "Link to itself must include a rel and type parameter");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForOtherResources(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Collections Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        HashSet<String> rels = new HashSet<String>();
        rels.add("self");
        rels.add("alternate");
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(alternateLinks, rels);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }
}

