/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;

public class GeometricShapeFactory {
    protected GeometryFactory geomFact;
    protected PrecisionModel precModel = null;
    protected Dimensions dim = new Dimensions();
    protected int nPts = 100;

    public GeometricShapeFactory() {
        this(new GeometryFactory());
    }

    public GeometricShapeFactory(GeometryFactory geomFact) {
        this.geomFact = geomFact;
        this.precModel = geomFact.getPrecisionModel();
    }

    public void setEnvelope(Envelope env) {
        this.dim.setEnvelope(env);
    }

    public void setBase(Coordinate base) {
        this.dim.setBase(base);
    }

    public void setCentre(Coordinate centre) {
        this.dim.setCentre(centre);
    }

    public void setNumPoints(int nPts) {
        this.nPts = nPts;
    }

    public void setSize(double size) {
        this.dim.setSize(size);
    }

    public void setWidth(double width) {
        this.dim.setWidth(width);
    }

    public void setHeight(double height) {
        this.dim.setHeight(height);
    }

    public Polygon createRectangle() {
        double y;
        double x;
        int i;
        int ipt = 0;
        int nSide = this.nPts / 4;
        if (nSide < 1) {
            nSide = 1;
        }
        double XsegLen = this.dim.getEnvelope().getWidth() / (double)nSide;
        double YsegLen = this.dim.getEnvelope().getHeight() / (double)nSide;
        Coordinate[] pts = new Coordinate[4 * nSide + 1];
        Envelope env = this.dim.getEnvelope();
        double maxx = env.getMinX() + (double)nSide * XsegLen;
        double maxy = env.getMinY() + (double)nSide * XsegLen;
        for (i = 0; i < nSide; ++i) {
            x = env.getMinX() + (double)i * XsegLen;
            y = env.getMinY();
            pts[ipt++] = this.createCoord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMaxX();
            y = env.getMinY() + (double)i * YsegLen;
            pts[ipt++] = this.createCoord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMaxX() - (double)i * XsegLen;
            y = env.getMaxY();
            pts[ipt++] = this.createCoord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMinX();
            y = env.getMaxY() - (double)i * YsegLen;
            pts[ipt++] = this.createCoord(x, y);
        }
        pts[ipt++] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return poly;
    }

    public Polygon createCircle() {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        Coordinate[] pts = new Coordinate[this.nPts + 1];
        int iPt = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double ang = (double)i * (Math.PI * 2 / (double)this.nPts);
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.createCoord(x, y);
        }
        pts[iPt] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return poly;
    }

    public Polygon createSquircle() {
        return this.createSupercircle(4.0);
    }

    public Polygon createSupercircle(double power) {
        double recipPow = 1.0 / power;
        Envelope env = this.dim.getEnvelope();
        double radius = this.dim.getMinSize() / 2.0;
        Coordinate centre = this.dim.getCentre();
        double r4 = Math.pow(radius, power);
        double y0 = radius;
        double xyInt = Math.pow(r4 / 2.0, recipPow);
        int nSegsInOct = this.nPts / 8;
        int totPts = nSegsInOct * 8 + 1;
        Coordinate[] pts = new Coordinate[totPts];
        double xInc = xyInt / (double)nSegsInOct;
        for (int i = 0; i <= nSegsInOct; ++i) {
            double x = 0.0;
            double y = y0;
            if (i != 0) {
                x = xInc * (double)i;
                double x4 = Math.pow(x, power);
                y = Math.pow(r4 - x4, recipPow);
            }
            pts[i] = this.createCoordTrans(x, y, centre);
            pts[2 * nSegsInOct - i] = this.createCoordTrans(y, x, centre);
            pts[2 * nSegsInOct + i] = this.createCoordTrans(y, -x, centre);
            pts[4 * nSegsInOct - i] = this.createCoordTrans(x, -y, centre);
            pts[4 * nSegsInOct + i] = this.createCoordTrans(-x, -y, centre);
            pts[6 * nSegsInOct - i] = this.createCoordTrans(-y, -x, centre);
            pts[6 * nSegsInOct + i] = this.createCoordTrans(-y, x, centre);
            pts[8 * nSegsInOct - i] = this.createCoordTrans(-x, y, centre);
        }
        pts[pts.length - 1] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return poly;
    }

    public LineString createArc(double startAng, double angExtent) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts - 1);
        Coordinate[] pts = new Coordinate[this.nPts];
        int iPt = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double ang = startAng + (double)i * angInc;
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.createCoord(x, y);
        }
        LineString line = this.geomFact.createLineString(pts);
        return line;
    }

    public Polygon createArcPolygon(double startAng, double angExtent) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts - 1);
        Coordinate[] pts = new Coordinate[this.nPts + 2];
        int iPt = 0;
        pts[iPt++] = this.createCoord(centreX, centreY);
        for (int i = 0; i < this.nPts; ++i) {
            double ang = startAng + angInc * (double)i;
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.createCoord(x, y);
        }
        pts[iPt++] = this.createCoord(centreX, centreY);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon geom = this.geomFact.createPolygon(ring, null);
        return geom;
    }

    protected Coordinate createCoord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.precModel.makePrecise(pt);
        return pt;
    }

    protected Coordinate createCoordTrans(double x, double y, Coordinate trans) {
        return this.createCoord(x + trans.x, y + trans.y);
    }

    protected class Dimensions {
        public Coordinate base;
        public Coordinate centre;
        public double width;
        public double height;

        protected Dimensions() {
        }

        public void setBase(Coordinate base) {
            this.base = base;
        }

        public Coordinate getBase() {
            return this.base;
        }

        public void setCentre(Coordinate centre) {
            this.centre = centre;
        }

        public Coordinate getCentre() {
            return this.centre;
        }

        public void setSize(double size) {
            this.height = size;
            this.width = size;
        }

        public double getMinSize() {
            return Math.min(this.width, this.height);
        }

        public void setWidth(double width) {
            this.width = width;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public void setEnvelope(Envelope env) {
            this.width = env.getWidth();
            this.height = env.getHeight();
            this.base = new Coordinate(env.getMinX(), env.getMinY());
            this.centre = new Coordinate(env.centre());
        }

        public Envelope getEnvelope() {
            if (this.base != null) {
                return new Envelope(this.base.x, this.base.x + this.width, this.base.y, this.base.y + this.height);
            }
            if (this.centre != null) {
                return new Envelope(this.centre.x - this.width / 2.0, this.centre.x + this.width / 2.0, this.centre.y - this.height / 2.0, this.centre.y + this.height / 2.0);
            }
            return new Envelope(0.0, this.width, 0.0, this.height);
        }
    }
}

