/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;

public final class InternalUtilities
extends Static {
    public static final double COMPARISON_THRESHOLD = 1.0E-14;
    public static final double LINEAR_TOLERANCE = 1.0;
    public static final double ANGULAR_TOLERANCE = 8.999280057595392E-6;
    private static final double EPS = 1.0E-8;
    private static final int ULP_TOLERANCE = 4;

    private InternalUtilities() {
    }

    public static String identity(Object object) {
        return Classes.getShortClassName(object) + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static boolean isPoleToPole(double d, double d2) {
        return Math.abs(d + 90.0) <= 8.999280057595392E-6 && Math.abs(d2 - 90.0) <= 8.999280057595392E-6;
    }

    public static boolean epsilonEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean epsilonEqual(double d, double d2, ComparisonMode comparisonMode) {
        switch (comparisonMode) {
            default: {
                return Utilities.equals(d, d2);
            }
            case APPROXIMATIVE: {
                return InternalUtilities.epsilonEqual(d, d2);
            }
            case DEBUG: 
        }
        boolean bl = InternalUtilities.epsilonEqual(d, d2);
        assert (bl) : "v1=" + d + " v2=" + d2 + " \u0394v=" + Math.abs(d - d2);
        return bl;
    }

    public static boolean epsilonEqual(double d, double d2) {
        double d3 = 1.0E-14 * Math.max(Math.abs(d), Math.abs(d2));
        if (d3 == Double.POSITIVE_INFINITY || Double.isNaN(d3)) {
            return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
        }
        return Math.abs(d - d2) <= d3;
    }

    public static boolean floatEpsilonEqual(Object object, Object object2) {
        return !(!(object instanceof Float) && !(object instanceof Double) || !(object2 instanceof Float) && !(object2 instanceof Double) || !InternalUtilities.epsilonEqual(((Number)object).doubleValue(), ((Number)object2).doubleValue()));
    }

    public static boolean debugEquals(Object object, Object object2) throws AssertionError {
        return Utilities.deepEquals(object, object2, ComparisonMode.DEBUG);
    }

    public static double adjustForRoundingError(double d, double d2, int n) {
        double d3 = Math.rint(d * (d2 = Math.abs(d2))) / d2;
        return Math.abs(d - d3) <= (double)n * Math.ulp(d) ? d3 : d;
    }

    public static double adjustForRoundingError(double d) {
        return InternalUtilities.adjustForRoundingError(d, 360.0, 4);
    }

    public static double convert10(float f) {
        return Double.parseDouble(Float.toString(f));
    }

    public static <T> Set<T> nonEmptySet(T ... TArray) {
        Set<T> set = XCollections.immutableSet(TArray);
        return set != null && set.isEmpty() ? null : set;
    }

    public static <K, V> Map<K, V> subset(Map<?, ?> map, Class<V> clazz, K ... KArray) throws ClassCastException {
        Map<K, V> map2 = null;
        if (map != null) {
            map2 = new HashMap(XCollections.hashMapCapacity(Math.min(map.size(), KArray.length)));
            for (K k : KArray) {
                V v = clazz.cast(map.get(k));
                if (v == null) continue;
                map2.put(k, v);
            }
            map2 = XCollections.unmodifiableMap(map2);
        }
        return map2;
    }

    public static <E> E firstNonNull(Iterable<E> iterable) {
        if (iterable != null) {
            for (E e : iterable) {
                if (e == null) continue;
                return e;
            }
        }
        return null;
    }

    public static char getSeparator(NumberFormat numberFormat) {
        char c;
        if (numberFormat instanceof DecimalFormat && (c = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator()) == ',') {
            return ';';
        }
        return ',';
    }

    public static void configure(NumberFormat numberFormat, double d, int n) {
        double d2;
        int n2;
        d = Math.abs(d);
        if (numberFormat instanceof DecimalFormat) {
            d *= (double)((DecimalFormat)numberFormat).getMultiplier();
        }
        for (n2 = 0; n2 < n && (d2 = Math.rint(d * 10000.0) % 10000.0) > d * 1.0E-8; ++n2) {
            d *= 10.0;
        }
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setMaximumFractionDigits(n2);
    }

    public static int parseColor(String string) throws NumberFormatException {
        if ((string = string.trim()).startsWith("#")) {
            String string2 = string.substring(1);
            int n = (int)Long.parseLong(string2, 16);
            switch (string2.length()) {
                case 3: {
                    n |= 0xF000;
                }
                case 4: {
                    int n2 = n & 0xF000;
                    int n3 = (n2 | n2 << 4) << 12;
                    n2 = n & 0xF00;
                    int n4 = n3 | (n2 | n2 << 4) << 8;
                    n2 = n & 0xF0;
                    int n5 = n4 | (n2 | n2 << 4) << 4;
                    n2 = n & 0xF;
                    return n5 | (n2 | n2 << 4);
                }
                case 6: {
                    n |= 0xFF000000;
                }
                case 8: {
                    return n;
                }
            }
        } else {
            long l = Long.decode(string);
            int n = (int)l;
            if ((long)n == l) {
                if ((n & 0xFF000000) == 0) {
                    n |= 0xFF000000;
                }
                return n;
            }
        }
        throw new NumberFormatException(Errors.format(73, "color", string));
    }
}

