/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.landingpage;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.testng.annotations.Test;

public class LandingPage
extends CommonFixture {
    private JsonPath jsonPath;

    private boolean is200Response(URI uri) {
        URL url = null;
        int code = 0;
        try {
            url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            code = connection.getResponseCode();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return code == 200;
    }

    @Test(description="Implements Abstract Test 2 (/conf/core/root-op) and Abstract Test 3 (/conf/core/root-success) - Landing Page validation", groups={"landingpage"})
    public void edrLandingPageValidation() {
        String f = "";
        if (!this.rootUri.toString().contains("f=json") && !this.rootUri.toString().contains("f=application/json")) {
            f = "f=application/json";
        }
        Response response = null;
        if (this.is200Response(URI.create(this.rootUri.toString() + "?f=application/json"))) {
            response = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "?f=application/json", new Object[0]);
            ((ValidatableResponse)response.then()).statusCode(200);
        } else if (this.is200Response(URI.create(this.rootUri.toString() + "?f=json"))) {
            response = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "?f=json", new Object[0]);
            ((ValidatableResponse)response.then()).statusCode(200);
        }
        this.jsonPath = response.jsonPath();
        List links = this.jsonPath.getList("links");
        Set<String> linkTypes = this.collectLinkTypes(links);
        boolean expectedLinkTypesExists = (linkTypes.contains("service-desc") || linkTypes.contains("service-doc")) && linkTypes.contains("conformance") && linkTypes.contains("data");
        EtsAssert.assertTrue(expectedLinkTypesExists, "The landing page must include at least links with relation types ('service-desc' and/or 'service-doc' ) and 'data' and 'conformance', but contains " + String.join((CharSequence)", ", linkTypes));
    }

    private Set<String> collectLinkTypes(List<Object> links) {
        HashSet<String> linkTypes = new HashSet<String>();
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            linkTypes.add((String)linkType);
        }
        return linkTypes;
    }
}

