/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.console;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.geotoolkit.console.InteractiveConsole;
import org.geotoolkit.console.ReferencingCommands;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.io.wkt.WKTFormat;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.crs.AbstractCRS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.IndexedResourceBundle;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class ReferencingConsole
extends InteractiveConsole {
    private final CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(null);
    private final WKTFormat parser;
    private CoordinateReferenceSystem sourceCRS;
    private CoordinateReferenceSystem targetCRS;
    private DirectPosition sourcePosition;
    private DirectPosition targetPosition;
    private MathTransform transform;
    private double[] tolerance;
    private double[] toleranceInverse;

    ReferencingConsole(ReferencingCommands referencingCommands) {
        super(referencingCommands);
        WKTFormat wKTFormat = new WKTFormat();
        String string = referencingCommands.authority;
        if (string != null) {
            wKTFormat.setAuthority(Citations.fromName(string));
        }
        if (Boolean.TRUE.equals(referencingCommands.colors)) {
            wKTFormat.setColors(Colors.DEFAULT);
        }
        wKTFormat.setIndentation(referencingCommands.indent);
        this.parser = wKTFormat;
        this.initialize();
    }

    protected ReferencingConsole(LineNumberReader lineNumberReader) {
        super(lineNumberReader);
        this.parser = new WKTFormat();
        this.initialize();
    }

    private void initialize() {
        super.setPrompt("geotk-ct \u25b6 ");
        Symbols symbols = this.parser.getSymbols();
        super.setSymbols(symbols.getOpeningBrackets(), symbols.getClosingBrackets(), symbols.getQuote());
    }

    private void loadDefinitions(BufferedReader bufferedReader) throws IOException {
        String string;
        Map<String, String> map = this.parser.definitions();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty() || string.startsWith("//") || string.startsWith("#")) continue;
            String string2 = string;
            String string3 = null;
            int n = string.indexOf(61);
            if (n >= 0) {
                string2 = string.substring(0, n).trim();
                string3 = string.substring(n + 1).trim();
            }
            try {
                map.put(string2, string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ContentFormatException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
            }
        }
    }

    private void printDefinitions() {
        try {
            this.parser.printDefinitions(this.out);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private void update() throws FactoryException {
        if (this.transform == null && this.sourceCRS != null && this.targetCRS != null) {
            this.transform = this.factory.createOperation(this.sourceCRS, this.targetCRS).getMathTransform();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(String string) throws Exception {
        String string2;
        String string3;
        int n = string.indexOf(61);
        if (n >= 0) {
            string3 = string.substring(0, n).trim();
            int n2 = string.length();
            while (++n < n2 && Character.isWhitespace(string.charAt(n))) {
            }
            string2 = string.substring(n).trim();
        } else {
            string3 = string;
            string2 = null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                if (string4.equalsIgnoreCase("transform")) {
                    this.transform = this.parser.parse(string, n, MathTransform.class);
                    this.sourceCRS = null;
                    this.targetCRS = null;
                    return;
                }
            } else {
                String string5 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    if (string4.equalsIgnoreCase("print")) {
                        if (string2 != null) {
                            throw this.unexpectedArgument(206, "print");
                        }
                        if (string5.equalsIgnoreCase("set")) {
                            this.printDefinitions();
                            return;
                        }
                        if (string5.equalsIgnoreCase("crs")) {
                            this.printCRS();
                            return;
                        }
                        if (string5.equalsIgnoreCase("mt")) {
                            this.printTransforms();
                            return;
                        }
                        if (string5.equalsIgnoreCase("pts")) {
                            this.printPts();
                            return;
                        }
                        throw this.unexpectedArgument(83, string5);
                    }
                    if (string4.equalsIgnoreCase("load")) {
                        if (string2 != null) {
                            throw this.unexpectedArgument(206, "load");
                        }
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(string5));
                        try {
                            this.loadDefinitions(bufferedReader);
                        }
                        finally {
                            bufferedReader.close();
                        }
                        return;
                    }
                    if (string4.equalsIgnoreCase("set")) {
                        this.parser.definitions().put(string5, string2);
                        return;
                    }
                    if (string4.equalsIgnoreCase("tolerance")) {
                        if (string5.equalsIgnoreCase("forward")) {
                            this.tolerance = this.parseVector(string2, true);
                            return;
                        }
                        if (string5.equalsIgnoreCase("inverse")) {
                            this.toleranceInverse = this.parseVector(string2, true);
                            return;
                        }
                        throw this.unexpectedArgument(83, string5);
                    }
                    if (string5.equalsIgnoreCase("crs")) {
                        if (string4.equalsIgnoreCase("source")) {
                            this.sourceCRS = this.parser.parse(string, n, CoordinateReferenceSystem.class);
                            this.transform = null;
                            return;
                        }
                        if (string4.equalsIgnoreCase("target")) {
                            this.targetCRS = this.parser.parse(string, n, CoordinateReferenceSystem.class);
                            this.transform = null;
                            return;
                        }
                    }
                    if (string5.equalsIgnoreCase("pt")) {
                        if (string4.equalsIgnoreCase("source")) {
                            this.sourcePosition = new GeneralDirectPosition(this.parseVector(string2, false));
                            return;
                        }
                        if (string4.equalsIgnoreCase("target")) {
                            this.targetPosition = new GeneralDirectPosition(this.parseVector(string2, false));
                            if ((this.tolerance != null || this.toleranceInverse != null) && this.sourcePosition != null) {
                                this.update();
                                if (this.transform != null) {
                                    this.test();
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
        super.execute(string);
    }

    private void header(Writer writer, String string) throws IOException {
        if (this.colors) {
            writer.write(X364.BOLD.sequence());
        }
        writer.write(string);
        if (this.colors) {
            writer.write(X364.NORMAL.sequence());
        }
    }

    private void printCRS() throws FactoryException, IOException {
        if (this.sourceCRS != null || this.targetCRS != null) {
            Vocabulary vocabulary = Vocabulary.getResources(this.locale);
            TableWriter tableWriter = new TableWriter((Writer)this.out, " \u2502 ");
            tableWriter.setMultiLinesCells(true);
            tableWriter.writeHorizontalSeparator();
            if (this.sourceCRS != null) {
                this.header(tableWriter, vocabulary.getString(273));
                tableWriter.writeHorizontalSeparator();
                tableWriter.write(this.parser.format(this.sourceCRS));
                if (this.targetCRS != null) {
                    tableWriter.nextLine();
                    tableWriter.nextLine('\u2550');
                }
            }
            if (this.targetCRS != null) {
                this.header(tableWriter, vocabulary.getString(289));
                tableWriter.writeHorizontalSeparator();
                tableWriter.write(this.parser.format(this.targetCRS));
            }
            tableWriter.writeHorizontalSeparator();
            tableWriter.flush();
        }
    }

    private void printTransforms() throws FactoryException, IOException {
        this.update();
        if (this.transform != null) {
            Vocabulary vocabulary = Vocabulary.getResources(this.locale);
            TableWriter tableWriter = new TableWriter((Writer)this.out, " \u2502 ");
            tableWriter.setMultiLinesCells(true);
            tableWriter.writeHorizontalSeparator();
            this.header(tableWriter, vocabulary.getString(188));
            tableWriter.nextColumn();
            this.header(tableWriter, vocabulary.getString(164));
            tableWriter.nextLine();
            tableWriter.writeHorizontalSeparator();
            tableWriter.write(this.parser.format(this.transform));
            tableWriter.nextColumn();
            try {
                tableWriter.write(this.parser.format(this.transform.inverse()));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                tableWriter.write(noninvertibleTransformException.getLocalizedMessage());
            }
            tableWriter.writeHorizontalSeparator();
            tableWriter.flush();
        }
    }

    private void printPts() throws FactoryException, TransformException, IOException {
        Object object;
        String string;
        DirectPosition directPosition;
        DirectPosition directPosition2;
        block9: {
            this.update();
            directPosition2 = null;
            directPosition = null;
            string = null;
            if (this.transform != null) {
                if (this.sourcePosition != null) {
                    directPosition2 = this.transform.transform(this.sourcePosition, null);
                }
                if (this.targetPosition != null) {
                    try {
                        directPosition = this.transform.inverse().transform(this.targetPosition, null);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        string = noninvertibleTransformException.getLocalizedMessage();
                        if (this.sourcePosition == null) break block9;
                        object = new GeneralDirectPosition(this.sourcePosition.getDimension());
                        directPosition = object;
                        Arrays.fill(((GeneralDirectPosition)object).ordinates, Double.NaN);
                    }
                }
            }
        }
        Locale locale = null;
        object = Vocabulary.getResources(locale);
        TableWriter tableWriter = new TableWriter((Writer)this.out, 0);
        tableWriter.setMultiLinesCells(true);
        tableWriter.writeHorizontalSeparator();
        tableWriter.setAlignment(2);
        if (this.sourcePosition != null) {
            tableWriter.write(((IndexedResourceBundle)object).getLabel(274));
            this.print(this.sourcePosition, tableWriter);
            this.print(directPosition2, tableWriter);
            tableWriter.nextLine();
        }
        if (this.targetPosition != null) {
            tableWriter.write(((IndexedResourceBundle)object).getLabel(290));
            this.print(directPosition, tableWriter);
            this.print(this.targetPosition, tableWriter);
            tableWriter.nextLine();
        }
        if (this.sourceCRS != null && this.targetCRS != null) {
            tableWriter.write(((IndexedResourceBundle)object).getLabel(79));
            this.printDistance(this.sourceCRS, this.sourcePosition, directPosition, tableWriter);
            this.printDistance(this.targetCRS, this.targetPosition, directPosition2, tableWriter);
            tableWriter.nextLine();
        }
        tableWriter.writeHorizontalSeparator();
        tableWriter.flush();
        if (string != null) {
            this.out.println(string);
        }
    }

    private void print(DirectPosition directPosition, TableWriter tableWriter) throws IOException {
        if (directPosition != null) {
            tableWriter.nextColumn();
            tableWriter.write("  (");
            double[] dArray = directPosition.getCoordinate();
            for (int i = 0; i < dArray.length; ++i) {
                if (i != 0) {
                    tableWriter.write(this.numberSeparator);
                    tableWriter.write(32);
                }
                tableWriter.nextColumn();
                tableWriter.write(this.numberFormat.format(dArray[i]));
            }
            tableWriter.write(41);
        }
    }

    private void printDistance(CoordinateReferenceSystem coordinateReferenceSystem, DirectPosition directPosition, DirectPosition directPosition2, TableWriter tableWriter) throws IOException {
        if (directPosition == null) {
            return;
        }
        int n = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        while (--n >= 0) {
            tableWriter.nextColumn();
        }
        if (directPosition2 != null && coordinateReferenceSystem instanceof AbstractCRS) {
            try {
                Measure measure = ((AbstractCRS)coordinateReferenceSystem).distance(directPosition.getCoordinate(), directPosition2.getCoordinate());
                tableWriter.setAlignment(2);
                tableWriter.write(this.numberFormat.format(measure.doubleValue()));
                tableWriter.write("  ");
                tableWriter.nextColumn();
                tableWriter.write(String.valueOf(measure.getUnit()));
                tableWriter.setAlignment(0);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        tableWriter.nextColumn();
    }

    protected void test() throws TransformException, MismatchedDimensionException {
        boolean bl = false;
        do {
            int n;
            int n2;
            Object object;
            CoordinateSystem coordinateSystem;
            DirectPosition directPosition;
            DirectPosition directPosition2;
            CoordinateReferenceSystem coordinateReferenceSystem;
            double[] dArray;
            double[] dArray2 = dArray = bl ? this.toleranceInverse : this.tolerance;
            if (dArray == null) continue;
            MathTransform mathTransform = this.transform;
            if (!bl) {
                coordinateReferenceSystem = this.targetCRS;
                directPosition2 = this.sourcePosition;
                directPosition = this.targetPosition;
            } else {
                coordinateReferenceSystem = this.sourceCRS;
                directPosition2 = this.targetPosition;
                directPosition = this.sourcePosition;
                mathTransform = mathTransform.inverse();
            }
            CoordinateSystem coordinateSystem2 = coordinateSystem = coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem() : null;
            if (coordinateSystem == null && mathTransform instanceof AbstractMathTransform && (object = ((AbstractMathTransform)mathTransform).getName()) != null && (((String)object).contains("Molodensky") || ((String)object).contains("Molodenski"))) {
                coordinateSystem = DefaultEllipsoidalCS.GEODETIC_3D;
            }
            if ((n2 = (object = mathTransform.transform(directPosition2, null)).getDimension()) != (n = directPosition.getDimension())) {
                throw new MismatchedDimensionException(Errors.format(112, n2, n));
            }
            for (int i = 0; i < n2; ++i) {
                CoordinateSystemAxis coordinateSystemAxis;
                double d = directPosition.getOrdinate(i);
                double d2 = object.getOrdinate(i);
                double d3 = Math.abs(d2 - d);
                if (coordinateSystem != null && i < coordinateSystem.getDimension() && RangeMeaning.WRAPAROUND.equals((coordinateSystemAxis = coordinateSystem.getAxis(i)).getRangeMeaning())) {
                    double d4;
                    double d5 = coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue();
                    d3 %= d5;
                    if (d4 > 0.5 * d5) {
                        d3 = d5 - d3;
                    }
                }
                if (d3 <= dArray[Math.min(i, dArray.length - 1)]) continue;
                throw new TransformException(Errors.format(212, new Number[]{d, d2, d3, i, bl ? 1 : 0}));
            }
        } while (bl = !bl);
    }
}

