/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.jaxb.gco.Measure;
import org.geotoolkit.internal.jaxb.referencing.SecondDefiningParameter;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.CoordinateFormat;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.datum.Spheroid;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.Ellipsoid;

@Immutable
@XmlType(name="EllipsoidType", propOrder={"semiMajorAxisMeasure", "secondDefiningParameter"})
@XmlRootElement(name="Ellipsoid")
public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    public static final DefaultEllipsoid WGS84 = DefaultEllipsoid.createFlattenedSphere(DefaultEllipsoid.properties("WGS84", 7030, "WGS 1984"), 6378137.0, 298.257223563, SI.METRE);
    public static final DefaultEllipsoid WGS72 = DefaultEllipsoid.createFlattenedSphere(DefaultEllipsoid.properties("WGS72", 7043, "WGS 1972"), 6378135.0, 298.26, SI.METRE);
    public static final DefaultEllipsoid GRS80 = DefaultEllipsoid.createFlattenedSphere(DefaultEllipsoid.properties("GRS80", 7019, new String[]{"GRS 1980", "International 1979"}), 6378137.0, 298.257222101, SI.METRE);
    public static final DefaultEllipsoid INTERNATIONAL_1924 = DefaultEllipsoid.createFlattenedSphere(DefaultEllipsoid.properties("International 1924", 7022, null), 6378388.0, 297.0, SI.METRE);
    public static final DefaultEllipsoid CLARKE_1866 = DefaultEllipsoid.createEllipsoid(DefaultEllipsoid.properties("Clarke 1866", 7008, null), 6378206.4, 6356583.8, SI.METRE);
    public static final DefaultEllipsoid SPHERE = DefaultEllipsoid.createEllipsoid("SPHERE", 6371000.0, 6371000.0, SI.METRE);
    private double semiMajorAxis;
    private double semiMinorAxis;
    private double inverseFlattening;
    private boolean ivfDefinitive;
    private Unit<Length> unit;

    private static Map<String, ?> properties(String string, int n, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", string);
        hashMap.put("identifiers", new NamedIdentifier(Citations.EPSG, String.valueOf(n)));
        if (object != null) {
            hashMap.put("alias", object);
        }
        return hashMap;
    }

    private DefaultEllipsoid() {
        super(NilReferencingObject.INSTANCE);
    }

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super(ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    protected DefaultEllipsoid(Map<String, ?> map, double d, double d2, double d3, boolean bl, Unit<Length> unit) {
        super(map);
        ArgumentChecks.ensureNonNull("unit", unit);
        this.unit = Units.ensureLinear(unit);
        this.semiMajorAxis = DefaultEllipsoid.check("semiMajorAxis", d);
        this.semiMinorAxis = DefaultEllipsoid.check("semiMinorAxis", d2);
        this.inverseFlattening = DefaultEllipsoid.check("inverseFlattening", d3);
        this.ivfDefinitive = bl;
    }

    private void completeSecondDefiningParameter() {
        if (this.semiMajorAxis != 0.0) {
            if (this.ivfDefinitive) {
                if (this.semiMinorAxis == 0.0 && this.inverseFlattening != 0.0) {
                    this.semiMinorAxis = this.semiMajorAxis * (1.0 - 1.0 / this.inverseFlattening);
                }
            } else if (this.inverseFlattening == 0.0 && this.semiMinorAxis != 0.0) {
                this.inverseFlattening = this.semiMajorAxis / (this.semiMajorAxis - this.semiMinorAxis);
            }
        }
    }

    public static DefaultEllipsoid createEllipsoid(String string, double d, double d2, Unit<Length> unit) {
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", string), d, d2, unit);
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (d == d2) {
            return new Spheroid(map, d, false, unit);
        }
        return new DefaultEllipsoid(map, d, d2, d / (d - d2), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(String string, double d, double d2, Unit<Length> unit) {
        return DefaultEllipsoid.createFlattenedSphere(Collections.singletonMap("name", string), d, d2, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (Double.isInfinite(d2)) {
            return new Spheroid(map, d, true, unit);
        }
        return new DefaultEllipsoid(map, d, d * (1.0 - 1.0 / d2), d2, true, unit);
    }

    public static DefaultEllipsoid castOrCopy(Ellipsoid ellipsoid) {
        if (ellipsoid == null || ellipsoid instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)ellipsoid;
        }
        Map<String, ?> map = IdentifiedObjects.getProperties(ellipsoid);
        double d = ellipsoid.getSemiMajorAxis();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        return ellipsoid.isIvfDefinitive() ? DefaultEllipsoid.createFlattenedSphere(map, d, ellipsoid.getInverseFlattening(), unit) : DefaultEllipsoid.createEllipsoid(map, d, ellipsoid.getSemiMinorAxis(), unit);
    }

    static double check(String string, double d) throws IllegalArgumentException {
        if (d > 0.0) {
            return d;
        }
        throw new IllegalArgumentException(Errors.format(73, string, d));
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @XmlElement(name="semiMajorAxis", required=true)
    final Measure getSemiMajorAxisMeasure() {
        return new Measure(this.semiMajorAxis, this.unit);
    }

    private void setSemiMajorAxisMeasure(Measure measure) {
        if (this.semiMajorAxis != 0.0) {
            throw new IllegalStateException();
        }
        this.semiMajorAxis = measure.value;
        this.unit = measure.unit.asType(Length.class);
        this.completeSecondDefiningParameter();
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getAuthalicRadius() {
        return CRSUtilities.getAuthalicRadius(this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public double getEccentricity() {
        double d = 1.0 - this.getSemiMinorAxis() / this.getSemiMajorAxis();
        return Math.sqrt(2.0 * d - d * d);
    }

    @Override
    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    @Override
    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    @XmlElement(name="secondDefiningParameter")
    final SecondDefiningParameter getSecondDefiningParameter() {
        return new SecondDefiningParameter(this, true);
    }

    private void setSecondDefiningParameter(SecondDefiningParameter secondDefiningParameter) throws ConversionException {
        while (secondDefiningParameter.secondDefiningParameter != null) {
            secondDefiningParameter = secondDefiningParameter.secondDefiningParameter;
        }
        Measure measure = secondDefiningParameter.measure;
        if (measure != null) {
            double d = measure.value;
            if (secondDefiningParameter.isIvfDefinitive()) {
                if (this.inverseFlattening == 0.0) {
                    this.inverseFlattening = d;
                    this.ivfDefinitive = true;
                    this.completeSecondDefiningParameter();
                    return;
                }
            } else {
                Unit<Length> unit = measure.unit;
                if (unit != null) {
                    if (this.unit != null) {
                        d = unit.getConverterToAny(this.unit).convert(d);
                    } else {
                        this.unit = unit.asType(Length.class);
                    }
                }
                if (this.semiMinorAxis == 0.0) {
                    this.semiMinorAxis = d;
                    this.ivfDefinitive = false;
                    this.completeSecondDefiningParameter();
                    return;
                }
            }
            throw new IllegalStateException();
        }
    }

    private void afterUnmarshal(Object object, Object object2) {
        if (this.ivfDefinitive) {
            this.semiMinorAxis = this.semiMajorAxis * (1.0 - 1.0 / this.inverseFlattening);
        } else {
            this.inverseFlattening = this.semiMajorAxis / (this.semiMajorAxis - this.semiMinorAxis);
        }
    }

    @Override
    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double orthodromicDistance(Point2D point2D, Point2D point2D2) {
        return this.orthodromicDistance(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public double orthodromicDistance(double d, double d2, double d3, double d4) {
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        d4 = Math.toRadians(d4);
        double d5 = 1.0 / this.getInverseFlattening();
        double d6 = 1.0 - d5;
        double d7 = d6 * Math.sin(d2) / Math.cos(d2);
        double d8 = d6 * Math.sin(d4) / Math.cos(d4);
        double d9 = 1.0 / Math.sqrt(d7 * d7 + 1.0);
        double d10 = 1.0 / Math.sqrt(d8 * d8 + 1.0);
        double d11 = d9 * d7;
        double d12 = d9 * d10;
        double d13 = d12 * d8;
        double d14 = d13 * d7;
        double d15 = d3 - d;
        for (int i = 0; i < 100; ++i) {
            double d16 = Math.sin(d15);
            double d17 = Math.cos(d15);
            d7 = d10 * d16;
            d8 = d13 - d11 * d10 * d17;
            double d18 = Math.hypot(d7, d8);
            double d19 = d12 * d17 + d14;
            double d20 = Math.atan2(d18, d19);
            double d21 = d12 * d16 / d18;
            double d22 = 1.0 - d21 * d21;
            double d23 = d14 + d14;
            if (d22 > 0.0) {
                d23 = -d23 / d22 + d19;
            }
            double d24 = d23 * d23 * 2.0 - 1.0;
            double d25 = ((-3.0 * d22 + 4.0) * d5 + 4.0) * d22 * d5 / 16.0;
            double d26 = d15;
            d15 = ((d24 * d19 * d25 + d23) * d18 * d25 + d20) * d21;
            if (!(Math.abs(d26 - (d15 = (1.0 - d25) * d15 * d5 + d3 - d)) <= 5.0E-14)) continue;
            d15 = Math.sqrt((1.0 / (d6 * d6) - 1.0) * d22 + 1.0) + 1.0;
            d15 = (d15 - 2.0) / d15;
            d25 = 1.0 - d15;
            d25 = (d15 * d15 / 4.0 + 1.0) / d25;
            d26 = (0.375 * d15 * d15 - 1.0) * d15;
            d15 = d24 * d19;
            d12 = 1.0 - 2.0 * d24;
            d12 = ((((d18 * d18 * 4.0 - 3.0) * d12 * d23 * d26 / 6.0 - d15) * d26 / 4.0 + d23) * d18 * d26 + d20) * d25 * d6 * this.getSemiMajorAxis();
            return d12;
        }
        if (Math.abs(d - d3) <= 1.0E-10 && Math.abs(d2 - d4) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(d2) <= 1.0E-10 && Math.abs(d4) <= 1.0E-10) {
            return Math.abs(d - d3) * this.getSemiMajorAxis();
        }
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            return Double.NaN;
        }
        CoordinateFormat coordinateFormat = new CoordinateFormat();
        throw new ArithmeticException(Errors.format(153, coordinateFormat.format(new DirectPosition2D(Math.toDegrees(d), Math.toDegrees(d2))), coordinateFormat.format(new DirectPosition2D(Math.toDegrees(d3), Math.toDegrees(d4)))));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)object;
                    return this.ivfDefinitive == defaultEllipsoid.ivfDefinitive && Utilities.equals(this.semiMajorAxis, defaultEllipsoid.semiMajorAxis) && Utilities.equals(this.semiMinorAxis, defaultEllipsoid.semiMinorAxis) && Utilities.equals(this.inverseFlattening, defaultEllipsoid.inverseFlattening) && Utilities.equals(this.unit, defaultEllipsoid.unit);
                }
                case BY_CONTRACT: {
                    if (this.isIvfDefinitive() == ((Ellipsoid)object).isIvfDefinitive()) break;
                    return false;
                }
            }
            Ellipsoid ellipsoid = (Ellipsoid)object;
            return InternalUtilities.epsilonEqual(this.getSemiMajorAxis(), ellipsoid.getSemiMajorAxis(), comparisonMode) && InternalUtilities.epsilonEqual(this.getSemiMinorAxis(), ellipsoid.getSemiMinorAxis(), comparisonMode) && InternalUtilities.epsilonEqual(this.getInverseFlattening(), ellipsoid.getInverseFlattening(), comparisonMode) && Utilities.equals(this.getAxisUnit(), ellipsoid.getAxisUnit());
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis, Utilities.hash(this.semiMajorAxis, super.computeHashCode()));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        double d = this.getInverseFlattening();
        formatter.append(this.getAxisUnit().getConverterTo(SI.METRE).convert(this.getSemiMajorAxis()));
        formatter.append(Double.isInfinite(d) ? 0.0 : d);
        return "SPHEROID";
    }
}

