/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.TemporalDatum;

@Immutable
@XmlType(name="TemporalDatumType")
@XmlRootElement(name="TemporalDatum")
public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    public static final DefaultTemporalDatum JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(167), new Date(-210866760000000L));
    public static final DefaultTemporalDatum MODIFIED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(196), new Date(-3506716800000L));
    public static final DefaultTemporalDatum TRUNCATED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(305), new Date(-50716800000L));
    public static final DefaultTemporalDatum DUBLIN_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(83), new Date(-2209032000000L));
    public static final DefaultTemporalDatum UNIX = new DefaultTemporalDatum("UNIX", new Date(0L));
    private final long origin;

    private DefaultTemporalDatum() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultTemporalDatum(TemporalDatum temporalDatum) {
        super(temporalDatum);
        this.origin = temporalDatum.getOrigin().getTime();
    }

    public DefaultTemporalDatum(String string, Date date) {
        this(Collections.singletonMap("name", string), date);
    }

    public DefaultTemporalDatum(Map<String, ?> map, Date date) {
        super(map);
        ArgumentChecks.ensureNonNull("origin", date);
        this.origin = date.getTime();
    }

    public static DefaultTemporalDatum castOrCopy(TemporalDatum temporalDatum) {
        return temporalDatum == null || temporalDatum instanceof DefaultTemporalDatum ? (DefaultTemporalDatum)temporalDatum : new DefaultTemporalDatum(temporalDatum);
    }

    @Override
    public Date getOrigin() {
        return new Date(this.origin);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultTemporalDatum defaultTemporalDatum = (DefaultTemporalDatum)object;
                    return this.origin == defaultTemporalDatum.origin;
                }
            }
            TemporalDatum temporalDatum = (TemporalDatum)object;
            return Utilities.equals(this.getOrigin(), temporalDatum.getOrigin());
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.origin, super.computeHashCode());
    }
}

