/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.FactoryUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.MultiAuthoritiesFactory;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

@ThreadSafe
public class AllAuthoritiesFactory
extends MultiAuthoritiesFactory {
    public static final Hints.Key USER_FACTORIES_KEY = new Hints.Key(Collection.class);
    private static final WeakHashSet<AllAuthoritiesFactory> POOL = WeakHashSet.newInstance(AllAuthoritiesFactory.class);
    private Collection<String> authorityNames;

    protected AllAuthoritiesFactory(Hints hints) {
        super((Collection<? extends AuthorityFactory>)null);
        FactoryUtilities.addImplementationHints(hints, this.hints);
        List<AuthorityFactory> list = (UnmodifiableArrayList<AuthorityFactory>)this.hints.get(USER_FACTORIES_KEY);
        list = !XCollections.isNullOrEmpty(list) ? UnmodifiableArrayList.wrap(list.toArray(new AuthorityFactory[list.size()])) : Collections.EMPTY_LIST;
        this.hints.put(USER_FACTORIES_KEY, list);
    }

    public static AllAuthoritiesFactory getInstance(Hints hints) {
        AllAuthoritiesFactory allAuthoritiesFactory = new AllAuthoritiesFactory(hints);
        if (allAuthoritiesFactory.getUserFactories().isEmpty()) {
            allAuthoritiesFactory = POOL.unique(allAuthoritiesFactory);
        }
        return allAuthoritiesFactory;
    }

    @Override
    public Set<String> getAuthorityNames() {
        Set<String> set = AllAuthoritiesFactory.getAuthorityNames(this.getUserFactories());
        set.addAll(AuthorityFactoryFinder.getAuthorityNames());
        return set;
    }

    private List<AuthorityFactory> getUserFactories() {
        return (List)this.hints.get(USER_FACTORIES_KEY);
    }

    @Override
    public synchronized List<AuthorityFactory> getFactories() {
        Set<String> set = AuthorityFactoryFinder.getAuthorityNames();
        if (set != this.authorityNames) {
            this.authorityNames = set;
            Hints hints = this.getHints();
            LinkedHashSet<AuthorityFactory> linkedHashSet = new LinkedHashSet<AuthorityFactory>(this.getUserFactories());
            Set<String> set2 = AllAuthoritiesFactory.getAuthorityNames(linkedHashSet);
            int n = 0;
            block6: while (true) {
                Set<AuthorityFactory> set3;
                switch (n) {
                    case 0: {
                        set3 = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactories(hints);
                        break;
                    }
                    case 1: {
                        set3 = AuthorityFactoryFinder.getDatumAuthorityFactories(hints);
                        break;
                    }
                    case 2: {
                        set3 = AuthorityFactoryFinder.getCSAuthorityFactories(hints);
                        break;
                    }
                    case 3: {
                        set3 = AuthorityFactoryFinder.getCRSAuthorityFactories(hints);
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                for (AuthorityFactory authorityFactory : set3) {
                    if (AllAuthoritiesFactory.isExcluded(authorityFactory) || set2.contains(Citations.getIdentifier(authorityFactory.getAuthority()))) continue;
                    linkedHashSet.add(authorityFactory);
                }
                ++n;
            }
            this.setFactories(linkedHashSet);
        }
        return super.getFactories();
    }

    @Override
    final <T extends AuthorityFactory> T fromFactoryRegistry(String string, Class<T> clazz) throws FactoryRegistryException {
        AuthorityFactory authorityFactory = clazz == CRSAuthorityFactory.class ? AuthorityFactoryFinder.getCRSAuthorityFactory(string, this.getHints()) : (clazz == CSAuthorityFactory.class ? AuthorityFactoryFinder.getCSAuthorityFactory(string, this.getHints()) : (clazz == DatumAuthorityFactory.class ? AuthorityFactoryFinder.getDatumAuthorityFactory(string, this.getHints()) : (clazz == CoordinateOperationAuthorityFactory.class ? AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(string, this.getHints()) : super.fromFactoryRegistry(string, clazz))));
        return (T)((AuthorityFactory)clazz.cast(authorityFactory));
    }

    private Hints getHints() {
        if (this.hints.isEmpty()) {
            return EMPTY_HINTS;
        }
        Hints hints = EMPTY_HINTS.clone();
        hints.putAll((Map<?, ?>)this.hints);
        return hints;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(this, clazz);
    }

    private static final class Finder
    extends MultiAuthoritiesFactory.Finder {
        protected Finder(MultiAuthoritiesFactory multiAuthoritiesFactory, Class<? extends IdentifiedObject> clazz) {
            super(multiAuthoritiesFactory, clazz);
        }

        private Set<AuthorityFactory> fromFactoryRegistry() {
            MultiAuthoritiesFactory multiAuthoritiesFactory = (MultiAuthoritiesFactory)this.factory;
            Class<? extends AuthorityFactory> clazz = this.getFactoryType();
            LinkedHashSet<AuthorityFactory> linkedHashSet = new LinkedHashSet<AuthorityFactory>();
            for (String string : AuthorityFactoryFinder.getAuthorityNames()) {
                multiAuthoritiesFactory.fromFactoryRegistry(string, clazz, linkedHashSet);
            }
            Collection<AuthorityFactory> collection = this.getFactories();
            if (collection != null) {
                linkedHashSet.removeAll(collection);
            }
            return linkedHashSet;
        }

        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObjectFinder identifiedObjectFinder;
            IdentifiedObject identifiedObject2 = super.find(identifiedObject);
            if (identifiedObject2 != null) {
                return identifiedObject2;
            }
            Iterator<AuthorityFactory> iterator = this.fromFactoryRegistry().iterator();
            while ((identifiedObjectFinder = this.next(iterator)) != null && (identifiedObject2 = identifiedObjectFinder.find(identifiedObject)) == null) {
            }
            return identifiedObject2;
        }
    }
}

