/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.openapi3;

import com.reprezen.kaizen.oasparser.model3.MediaType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class TestPoint {
    private final String serverUrl;
    private final String path;
    private Map<String, String> predefinedTemplateReplacement;
    private Map<String, MediaType> contentMediaTypes;

    public TestPoint(String serverUrl, String path, Map<String, MediaType> contentMediaTypes) {
        this(serverUrl, path, Collections.emptyMap(), contentMediaTypes);
    }

    public TestPoint(String serverUrl, String path, Map<String, String> predefinedTemplateReplacement, Map<String, MediaType> contentMediaTypes) {
        this.serverUrl = serverUrl;
        this.path = path;
        this.predefinedTemplateReplacement = Collections.unmodifiableMap(predefinedTemplateReplacement);
        this.contentMediaTypes = contentMediaTypes;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getPredefinedTemplateReplacement() {
        return this.predefinedTemplateReplacement;
    }

    public Map<String, MediaType> getContentMediaTypes() {
        return this.contentMediaTypes;
    }

    public String toString() {
        return "Server URL: " + this.serverUrl + " , Path: " + this.path + ", Replacements: " + this.predefinedTemplateReplacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestPoint testPoint = (TestPoint)o;
        return Objects.equals(this.serverUrl, testPoint.serverUrl) && Objects.equals(this.path, testPoint.predefinedTemplateReplacement) && Objects.equals(this.predefinedTemplateReplacement, testPoint.path) && Objects.equals(this.contentMediaTypes, testPoint.contentMediaTypes);
    }

    public int hashCode() {
        return Objects.hash(this.serverUrl, this.path, this.predefinedTemplateReplacement, this.contentMediaTypes);
    }
}

