/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.HashMap;
import java.util.Map;
import org.geotoolkit.util.ArgumentChecks;

public final class MapUtilities {
    private MapUtilities() {
    }

    public static <T> Map buildMap(T ... couples) {
        ArgumentChecks.ensureNonNull((String)"map values", couples);
        if (couples.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of values (not divisible per 2)");
        }
        HashMap<T, T> result = new HashMap<T, T>(couples.length / 2);
        int i = 0;
        while (i < couples.length) {
            result.put(couples[i++], couples[i++]);
        }
        return result;
    }
}

